/*
 * Decompiled with CFR 0.152.
 */
package antlr.collections.impl;

public class BitSet
implements Cloneable {
    public long[] bits;

    public BitSet() {
        this(64);
    }

    public BitSet(long[] lArray) {
        this.bits = lArray;
    }

    public BitSet(int n) {
        this.bits = new long[(n - 1 >> 6) + 1];
    }

    private final long bitMask(int n) {
        int n2 = n & 0x3F;
        return 1L << n2;
    }

    public final Object clone() {
        BitSet bitSet;
        try {
            bitSet = (BitSet)super.clone();
            bitSet.bits = new long[this.bits.length];
            System.arraycopy(this.bits, 0, bitSet.bits, 0, this.bits.length);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        return bitSet;
    }

    public final int degree() {
        int n = 0;
        int n2 = this.bits.length - 1;
        while (n2 >= 0) {
            long l = this.bits[n2];
            if (l != 0L) {
                int n3 = 63;
                while (n3 >= 0) {
                    if ((l & 1L << n3) != 0L) {
                        ++n;
                    }
                    --n3;
                }
            }
            --n2;
        }
        return n;
    }

    public final boolean equals(Object object) {
        if (object != null && object instanceof BitSet) {
            int n;
            BitSet bitSet = (BitSet)object;
            int n2 = n = Math.min(this.bits.length, bitSet.bits.length);
            while (n2-- > 0) {
                if (this.bits[n2] == bitSet.bits[n2]) continue;
                return false;
            }
            if (this.bits.length > n) {
                int n3 = this.bits.length;
                while (n3-- > n) {
                    if (this.bits[n3] == 0L) continue;
                    return false;
                }
            } else if (bitSet.bits.length > n) {
                int n4 = bitSet.bits.length;
                while (n4-- > n) {
                    if (bitSet.bits[n4] == 0L) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public final boolean member(int n) {
        int n2 = this.wordNumber(n);
        if (n2 > this.bits.length) {
            return false;
        }
        return (this.bits[n2] & this.bitMask(n)) != 0L;
    }

    public final int[] toArray() {
        int[] nArray = new int[this.degree()];
        int n = 0;
        int n2 = 0;
        while (n2 < this.bits.length << 6) {
            if (this.member(n2)) {
                nArray[n++] = n2;
            }
            ++n2;
        }
        return nArray;
    }

    public final String toString() {
        return this.toString(",");
    }

    public final String toString(String string) {
        String string2 = "";
        int n = 0;
        while (n < this.bits.length << 6) {
            if (this.member(n)) {
                if (string2.length() > 0) {
                    string2 = String.valueOf(string2) + string;
                }
                string2 = String.valueOf(string2) + n;
            }
            ++n;
        }
        return string2;
    }

    private final int wordNumber(int n) {
        return n >> 6;
    }
}

