/*
 * Decompiled with CFR 0.152.
 */
package de.cinderella.controls;

import de.cinderella.controls.MessageDialog;
import de.cinderella.controls.Preferences;
import java.io.IOException;

public class BrowserControl {
    public static final String WIN_ID = Preferences.getString("cinderella.winID", "Win");
    public static final String WIN_START = Preferences.getString("cinderella.winstart", "rundll32 url.dll,FileProtocolHandler");
    public static final String UNIX_PATH = Preferences.getString("cinderella.netscape", "netscape");
    public static final String UNIX_FLAG = Preferences.getString("cinderella.remote", "-remote openURL");

    public static void displayURL(String string) {
        boolean bl = BrowserControl.isWindowsPlatform();
        String string2 = null;
        try {
            if (bl) {
                if (string.startsWith("file://")) {
                    string = "file://" + string.substring(7).replace('/', '\\');
                }
                if (string.indexOf(35) != -1) {
                    string = string.substring(0, string.indexOf(35));
                }
                string2 = String.valueOf(WIN_START) + " " + string;
                System.err.println("Starting default browser with " + string2);
                Runtime.getRuntime().exec(string2);
                return;
            }
            string2 = String.valueOf(UNIX_PATH) + " " + UNIX_FLAG + "(" + string + ")";
            Process process = Runtime.getRuntime().exec(string2);
            try {
                int n = process.waitFor();
                if (n != 0) {
                    string2 = String.valueOf(UNIX_PATH) + " " + string;
                    process = Runtime.getRuntime().exec(string2);
                    return;
                }
            }
            catch (InterruptedException interruptedException) {
                MessageDialog.showMessage("NoBrowserTitle", "NoBrowserMsg");
                System.err.println("Error bringing up browser, cmd='" + string2 + "'");
                System.err.println("Caught: " + interruptedException);
                return;
            }
        }
        catch (IOException iOException) {
            MessageDialog.showMessage("NoBrowserTitle", "NoBrowserMsg");
            System.err.println("Could not invoke browser, command=" + string2);
            System.err.println("Caught: " + iOException);
        }
    }

    public static boolean isWindowsPlatform() {
        String string = System.getProperty("os.name");
        return string != null && string.startsWith(WIN_ID);
    }
}

