/*
 * Decompiled with CFR 0.152.
 */
package de.cinderella.controls;

import de.cinderella.controls.Preferences;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Toolkit;

public class LWLabel
extends Component {
    public Dimension pref = new Dimension();
    public Point pos = new Point();
    public String text;
    public Font font = Preferences.getFont("cinderella.dialog.font");
    public int border = 2;

    public LWLabel(String string) {
        this.setText(string);
    }

    public final void update(Graphics graphics) {
        this.paint(graphics);
    }

    public final Font getFont() {
        return this.font;
    }

    public final void setFont(Font font) {
        this.font = font;
        this.updateFM();
    }

    public final void setText(String string) {
        this.text = string;
        this.updateFM();
    }

    private final void updateFM() {
        if (this.text == null || this.font == null) {
            return;
        }
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.font);
        this.pref.width = fontMetrics.stringWidth(this.text) + 2 * this.border;
        this.pref.height = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent() + 2 * this.border;
        this.pos.x = this.border;
        this.pos.y = fontMetrics.getMaxAscent() + this.border;
    }

    public final Dimension getPreferredSize() {
        return this.pref;
    }

    public final void paint(Graphics graphics) {
        graphics.setFont(this.font);
        graphics.drawString(this.text, this.pos.x, this.pos.y);
    }
}

