/*
 * Decompiled with CFR 0.152.
 */
package de.cinderella.controls;

import de.cinderella.controls.EasyLayout;
import de.cinderella.controls.ImageButton;
import de.cinderella.controls.Intl;
import de.cinderella.controls.LWLabel;
import de.cinderella.controls.LWPanel;
import de.cinderella.controls.MenuConfiguration;
import de.cinderella.controls.ModeObject;
import de.cinderella.controls.Preferences;
import de.cinderella.controls.ResourceImage;
import de.cinderella.controls.WindowCloser;
import de.cinderella.geometry.Exercise;
import de.cinderella.ports.Appearance;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;

public final class MenuEditor
extends Dialog
implements ActionListener {
    public Exercise myExercise;
    public LWLabel topLabel;
    public LWPanel topPanel;
    public ModeObject[] tops;
    public LWLabel botLabel;
    public LWPanel botPanel;
    public ModeObject[] bots;
    public ImageButton defaultButton;
    public ImageButton clearButton;

    public MenuEditor(Exercise exercise) {
        super(ResourceImage.frame);
        this.myExercise = exercise;
        this.myExercise.f180 = this;
        if (this.myExercise.m64().size() == 0) {
            this.myExercise.m65();
        }
        this.setLayout(new EasyLayout());
        this.setModal(false);
        this.setTitle(Intl.getMessage("menuEditTitle"));
        ((Component)this).setFont(Appearance.helvetica);
        this.topLabel = new LWLabel(Intl.getMessage("menuTopName"));
        this.topPanel = new LWPanel();
        this.botLabel = new LWLabel(Intl.getMessage("menuBotName"));
        this.botPanel = new LWPanel();
        this.defaultButton = new ImageButton(Intl.getMessage("defaultMenu"));
        this.defaultButton.addActionListener(this);
        this.clearButton = new ImageButton(Intl.getMessage("clearMenu"));
        this.clearButton.addActionListener(this);
        this.updatePanels();
        this.addNotify();
        this.add("cn", this.topLabel);
        this.add("+c+n", this.topPanel);
        this.add("cn", this.botLabel);
        this.add("+c+n", this.botPanel);
        this.add("*c*", this.clearButton);
        this.add("c*n", this.defaultButton);
        this.pack();
        this.addWindowListener(WindowCloser.hide);
        this.setResizable(false);
    }

    public final void updatePanels() {
        this.tops = MenuConfiguration.getModesFromString(Preferences.getString("cinderella.exercise.menu"));
        int n = this.tops.length;
        int n2 = n / 4 * 4 == n ? 4 : (n / 5 * 5 == n ? 5 : 3);
        this.topPanel.setLayout(new GridLayout(n2, n / n2));
        this.topPanel.removeAll();
        int n3 = 0;
        while (n3 < this.tops.length) {
            this.tops[n3].setKernel(this.myExercise.f6);
            String string = this.tops[n3].getKey();
            ImageButton imageButton = new ImageButton(Intl.modenames.getString(string), Intl.icons.getString(string));
            imageButton.ttt = String.valueOf(Intl.getMessage("addMenuItem")) + "\"" + Intl.modenames.getString(string) + "\"";
            imageButton.t = this.tops[n3].getInstanceString();
            imageButton.addActionListener(this);
            this.topPanel.add(imageButton);
            ++n3;
        }
        this.botPanel.setLayout(new GridLayout(2, 6));
        this.updateBotPanel();
        this.repaint();
    }

    public final void updateBotPanel() {
        this.botPanel.removeAll();
        this.bots = MenuConfiguration.getModesFromVector(this.myExercise.m64());
        this.botPanel.setLayout(new GridLayout(2, 6));
        int n = 0;
        while (n < this.bots.length) {
            this.bots[n].setKernel(this.myExercise.f6);
            String string = this.bots[n].getKey();
            ImageButton imageButton = new ImageButton(Intl.modenames.getString(string), Intl.icons.getString(string));
            imageButton.ttt = String.valueOf(Intl.getMessage("removeMenuItem")) + "\"" + Intl.modenames.getString(string) + "\"";
            imageButton.t = this.bots[n].getInstanceString();
            imageButton.addActionListener(this);
            this.botPanel.add(imageButton);
            ++n;
        }
        int n2 = this.bots.length;
        while (n2 < 12) {
            this.botPanel.add(new ImageButton("empty", "empty.gif"));
            ++n2;
        }
        this.botPanel.invalidate();
        this.validate();
        this.botPanel.repaint();
    }

    public final void actionPerformed(ActionEvent actionEvent) {
        Vector vector;
        Component component = (Component)actionEvent.getSource();
        Container container = component.getParent();
        if (container == this.topPanel) {
            vector = this.myExercise.m64();
            if (vector.size() < 12 && !vector.contains(actionEvent.getActionCommand())) {
                this.myExercise.addMode(actionEvent.getActionCommand());
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
            this.updateBotPanel();
        }
        if (container == this.botPanel) {
            vector = this.myExercise.m64();
            if (!vector.removeElement(actionEvent.getActionCommand())) {
                Toolkit.getDefaultToolkit().beep();
            }
            this.updateBotPanel();
        }
        if (component == this.defaultButton) {
            this.myExercise.m65();
            this.updateBotPanel();
        }
        if (component == this.clearButton) {
            this.myExercise.f25 = new Vector();
            this.updateBotPanel();
        }
    }
}

