/*
 * Decompiled with CFR 0.152.
 */
package de.cinderella.math;

import de.cinderella.geometry.PGFormat;
import de.cinderella.geometry.Restorer;
import de.cinderella.math.Assignable;
import de.cinderella.math.Mat;
import de.cinderella.math.Tracable;
import de.cinderella.math.Vec;
import java.io.Serializable;
import java.text.DecimalFormat;

public final class Complex
implements Serializable,
Tracable,
Assignable,
Restorer {
    public static final Complex one;
    public static final Complex e1;
    public static final Complex e2;
    public double real;
    public double imag;
    public int invalid;

    public Complex() {
        this.real = 0.0;
        this.imag = 0.0;
        this.invalid = 0;
    }

    public Complex(double d) {
        this.real = d;
        this.imag = 0.0;
        this.invalid = 0;
    }

    public Complex(double d, double d2) {
        this.real = d;
        this.imag = d2;
        this.invalid = 0;
    }

    public Complex(Complex complex) {
        this.real = complex.real;
        this.imag = complex.imag;
        this.invalid = complex.invalid;
    }

    public final void assign(Assignable assignable) {
        this.assign((Complex)assignable);
    }

    public final boolean equals(Complex complex) {
        return this.real == complex.real && this.imag == complex.imag && this.invalid == complex.invalid;
    }

    public final Object clone() {
        return new Complex(this);
    }

    public final boolean resembles(Object object) {
        return this.equals((Complex)object);
    }

    public final void restore(Object object) {
        ((Complex)object).assign(this);
    }

    public final void save(Object object) {
        this.assign((Complex)object);
    }

    public final Complex assign(Complex complex) {
        this.real = complex.real;
        this.imag = complex.imag;
        this.invalid = complex.invalid;
        return this;
    }

    public final Complex assign(double d, double d2) {
        this.real = d;
        this.imag = d2;
        this.invalid = 0;
        return this;
    }

    public final Complex assign(double d) {
        this.real = d;
        this.imag = 0.0;
        this.invalid = 0;
        return this;
    }

    public final Complex y(Vec vec) {
        this.real = vec.yr;
        this.imag = vec.yi;
        return this;
    }

    public final Complex z(Vec vec) {
        this.real = vec.zr;
        this.imag = vec.zi;
        return this;
    }

    public final Complex ax(Mat mat) {
        this.real = mat.axr;
        this.imag = mat.axi;
        return this;
    }

    public final Complex bx(Mat mat) {
        this.real = mat.bxr;
        this.imag = mat.bxi;
        return this;
    }

    public final Complex cx(Mat mat) {
        this.real = mat.cxr;
        this.imag = mat.cxi;
        return this;
    }

    public final Complex ay(Mat mat) {
        this.real = mat.ayr;
        this.imag = mat.ayi;
        return this;
    }

    public final Complex by(Mat mat) {
        this.real = mat.byr;
        this.imag = mat.byi;
        return this;
    }

    public final Complex cy(Mat mat) {
        this.real = mat.cyr;
        this.imag = mat.cyi;
        return this;
    }

    public final Complex az(Mat mat) {
        this.real = mat.azr;
        this.imag = mat.azi;
        return this;
    }

    public final Complex bz(Mat mat) {
        this.real = mat.bzr;
        this.imag = mat.bzi;
        return this;
    }

    public final Complex cz(Mat mat) {
        this.real = mat.czr;
        this.imag = mat.czi;
        return this;
    }

    public final Complex add(Complex complex) {
        this.real += complex.real;
        this.imag += complex.imag;
        return this;
    }

    public final Complex add(double d) {
        this.real += d;
        return this;
    }

    public final Complex sum(Complex complex, Complex complex2) {
        this.real = complex.real + complex2.real;
        this.imag = complex.imag + complex2.imag;
        return this;
    }

    public final Complex mul(Complex complex) {
        double d = this.real * complex.real - this.imag * complex.imag;
        double d2 = this.imag * complex.real + this.real * complex.imag;
        this.real = d;
        this.imag = d2;
        return this;
    }

    public final Complex mul(double d) {
        this.real *= d;
        this.imag *= d;
        return this;
    }

    public final Complex prod(Complex complex, Complex complex2) {
        this.real = complex.real * complex2.real - complex.imag * complex2.imag;
        this.imag = complex.imag * complex2.real + complex.real * complex2.imag;
        return this;
    }

    public final Complex sub(Complex complex) {
        this.real -= complex.real;
        this.imag -= complex.imag;
        return this;
    }

    public final Complex div(Complex complex) {
        double d = complex.real * complex.real + complex.imag * complex.imag;
        double d2 = (this.real * complex.real + this.imag * complex.imag) / d;
        double d3 = (-this.real * complex.imag + this.imag * complex.real) / d;
        this.real = d2;
        this.imag = d3;
        return this;
    }

    public final Complex div(double d) {
        this.real /= d;
        this.imag /= d;
        return this;
    }

    public final Complex quot(Complex complex, Complex complex2) {
        double d = complex2.real * complex2.real + complex2.imag * complex2.imag;
        this.real = (complex.real * complex2.real + complex.imag * complex2.imag) / d;
        this.imag = (complex.real * complex2.imag - complex.imag * complex2.real) / d;
        return this;
    }

    public final Complex neg() {
        this.real = -this.real;
        this.imag = -this.imag;
        return this;
    }

    public final Complex inv() {
        double d = this.real * this.real + this.imag * this.imag;
        this.real /= d;
        this.imag = -this.imag / d;
        return this;
    }

    public final double abs2() {
        return this.real * this.real + this.imag * this.imag;
    }

    public final Complex det(Vec vec, Vec vec2, Vec vec3) {
        this.real = vec.xr * vec2.yr * vec3.zr - vec.xi * vec2.yi * vec3.zr - vec.xi * vec2.yr * vec3.zi - vec.xr * vec2.yi * vec3.zi + vec.zr * vec2.xr * vec3.yr - vec.zi * vec2.xi * vec3.yr - vec.zi * vec2.xr * vec3.yi - vec.zr * vec2.xi * vec3.yi + vec.yr * vec2.zr * vec3.xr - vec.yi * vec2.zi * vec3.xr - vec.yi * vec2.zr * vec3.xi - vec.yr * vec2.zi * vec3.xi - vec.xr * vec2.zr * vec3.yr + vec.xi * vec2.zi * vec3.yr + vec.xi * vec2.zr * vec3.yi + vec.xr * vec2.zi * vec3.yi - vec.zr * vec2.yr * vec3.xr + vec.zi * vec2.yi * vec3.xr + vec.zi * vec2.yr * vec3.xi + vec.zr * vec2.yi * vec3.xi - vec.yr * vec2.xr * vec3.zr + vec.yi * vec2.xi * vec3.zr + vec.yi * vec2.xr * vec3.zi + vec.yr * vec2.xi * vec3.zi;
        this.imag = -vec.xi * vec2.yi * vec3.zi + vec.xi * vec2.yr * vec3.zr + vec.xr * vec2.yr * vec3.zi + vec.xr * vec2.yi * vec3.zr - vec.zi * vec2.xi * vec3.yi + vec.zi * vec2.xr * vec3.yr + vec.zr * vec2.xr * vec3.yi + vec.zr * vec2.xi * vec3.yr - vec.yi * vec2.zi * vec3.xi + vec.yi * vec2.zr * vec3.xr + vec.yr * vec2.zr * vec3.xi + vec.yr * vec2.zi * vec3.xr + vec.xi * vec2.zi * vec3.yi - vec.xi * vec2.zr * vec3.yr - vec.xr * vec2.zr * vec3.yi - vec.xr * vec2.zi * vec3.yr + vec.zi * vec2.yi * vec3.xi - vec.zi * vec2.yr * vec3.xr - vec.zr * vec2.yr * vec3.xi - vec.zr * vec2.yi * vec3.xr + vec.yi * vec2.xi * vec3.zi - vec.yi * vec2.xr * vec3.zr - vec.yr * vec2.xr * vec3.zi - vec.yr * vec2.xi * vec3.zr;
        return this;
    }

    public final Complex det(Mat mat) {
        this.real = mat.axr * mat.byr * mat.czr - mat.axi * mat.byi * mat.czr - mat.axi * mat.byr * mat.czi - mat.axr * mat.byi * mat.czi + mat.azr * mat.bxr * mat.cyr - mat.azi * mat.bxi * mat.cyr - mat.azi * mat.bxr * mat.cyi - mat.azr * mat.bxi * mat.cyi + mat.ayr * mat.bzr * mat.cxr - mat.ayi * mat.bzi * mat.cxr - mat.ayi * mat.bzr * mat.cxi - mat.ayr * mat.bzi * mat.cxi - mat.axr * mat.bzr * mat.cyr + mat.axi * mat.bzi * mat.cyr + mat.axi * mat.bzr * mat.cyi + mat.axr * mat.bzi * mat.cyi - mat.azr * mat.byr * mat.cxr + mat.azi * mat.byi * mat.cxr + mat.azi * mat.byr * mat.cxi + mat.azr * mat.byi * mat.cxi - mat.ayr * mat.bxr * mat.czr + mat.ayi * mat.bxi * mat.czr + mat.ayi * mat.bxr * mat.czi + mat.ayr * mat.bxi * mat.czi;
        this.imag = -mat.axi * mat.byi * mat.czi + mat.axi * mat.byr * mat.czr + mat.axr * mat.byr * mat.czi + mat.axr * mat.byi * mat.czr - mat.azi * mat.bxi * mat.cyi + mat.azi * mat.bxr * mat.cyr + mat.azr * mat.bxr * mat.cyi + mat.azr * mat.bxi * mat.cyr - mat.ayi * mat.bzi * mat.cxi + mat.ayi * mat.bzr * mat.cxr + mat.ayr * mat.bzr * mat.cxi + mat.ayr * mat.bzi * mat.cxr + mat.axi * mat.bzi * mat.cyi - mat.axi * mat.bzr * mat.cyr - mat.axr * mat.bzr * mat.cyi - mat.axr * mat.bzi * mat.cyr + mat.azi * mat.byi * mat.cxi - mat.azi * mat.byr * mat.cxr - mat.azr * mat.byr * mat.cxi - mat.azr * mat.byi * mat.cxr + mat.ayi * mat.bxi * mat.czi - mat.ayi * mat.bxr * mat.czr - mat.ayr * mat.bxr * mat.czi - mat.ayr * mat.bxi * mat.czr;
        return this;
    }

    public final Complex mixedDet(Mat mat, Mat mat2) {
        this.real = mat.axr * mat2.byr * mat2.czr - mat.axi * mat2.byi * mat2.czr - mat.axi * mat2.byr * mat2.czi - mat.axr * mat2.byi * mat2.czi + mat.azr * mat2.bxr * mat2.cyr - mat.azi * mat2.bxi * mat2.cyr - mat.azi * mat2.bxr * mat2.cyi - mat.azr * mat2.bxi * mat2.cyi + mat.ayr * mat2.bzr * mat2.cxr - mat.ayi * mat2.bzi * mat2.cxr - mat.ayi * mat2.bzr * mat2.cxi - mat.ayr * mat2.bzi * mat2.cxi - mat.axr * mat2.bzr * mat2.cyr + mat.axi * mat2.bzi * mat2.cyr + mat.axi * mat2.bzr * mat2.cyi + mat.axr * mat2.bzi * mat2.cyi - mat.azr * mat2.byr * mat2.cxr + mat.azi * mat2.byi * mat2.cxr + mat.azi * mat2.byr * mat2.cxi + mat.azr * mat2.byi * mat2.cxi - mat.ayr * mat2.bxr * mat2.czr + mat.ayi * mat2.bxi * mat2.czr + mat.ayi * mat2.bxr * mat2.czi + mat.ayr * mat2.bxi * mat2.czi;
        this.imag = -mat.axi * mat2.byi * mat2.czi + mat.axi * mat2.byr * mat2.czr + mat.axr * mat2.byr * mat2.czi + mat.axr * mat2.byi * mat2.czr - mat.azi * mat2.bxi * mat2.cyi + mat.azi * mat2.bxr * mat2.cyr + mat.azr * mat2.bxr * mat2.cyi + mat.azr * mat2.bxi * mat2.cyr - mat.ayi * mat2.bzi * mat2.cxi + mat.ayi * mat2.bzr * mat2.cxr + mat.ayr * mat2.bzr * mat2.cxi + mat.ayr * mat2.bzi * mat2.cxr + mat.axi * mat2.bzi * mat2.cyi - mat.axi * mat2.bzr * mat2.cyr - mat.axr * mat2.bzr * mat2.cyi - mat.axr * mat2.bzi * mat2.cyr + mat.azi * mat2.byi * mat2.cxi - mat.azi * mat2.byr * mat2.cxr - mat.azr * mat2.byr * mat2.cxi - mat.azr * mat2.byi * mat2.cxr + mat.ayi * mat2.bxi * mat2.czi - mat.ayi * mat2.bxr * mat2.czr - mat.ayr * mat2.bxr * mat2.czi - mat.ayr * mat2.bxi * mat2.czr;
        this.real += mat2.axr * mat.byr * mat2.czr - mat2.axi * mat.byi * mat2.czr - mat2.axi * mat.byr * mat2.czi - mat2.axr * mat.byi * mat2.czi + mat2.azr * mat.bxr * mat2.cyr - mat2.azi * mat.bxi * mat2.cyr - mat2.azi * mat.bxr * mat2.cyi - mat2.azr * mat.bxi * mat2.cyi + mat2.ayr * mat.bzr * mat2.cxr - mat2.ayi * mat.bzi * mat2.cxr - mat2.ayi * mat.bzr * mat2.cxi - mat2.ayr * mat.bzi * mat2.cxi - mat2.axr * mat.bzr * mat2.cyr + mat2.axi * mat.bzi * mat2.cyr + mat2.axi * mat.bzr * mat2.cyi + mat2.axr * mat.bzi * mat2.cyi - mat2.azr * mat.byr * mat2.cxr + mat2.azi * mat.byi * mat2.cxr + mat2.azi * mat.byr * mat2.cxi + mat2.azr * mat.byi * mat2.cxi - mat2.ayr * mat.bxr * mat2.czr + mat2.ayi * mat.bxi * mat2.czr + mat2.ayi * mat.bxr * mat2.czi + mat2.ayr * mat.bxi * mat2.czi;
        this.imag += -mat2.axi * mat.byi * mat2.czi + mat2.axi * mat.byr * mat2.czr + mat2.axr * mat.byr * mat2.czi + mat2.axr * mat.byi * mat2.czr - mat2.azi * mat.bxi * mat2.cyi + mat2.azi * mat.bxr * mat2.cyr + mat2.azr * mat.bxr * mat2.cyi + mat2.azr * mat.bxi * mat2.cyr - mat2.ayi * mat.bzi * mat2.cxi + mat2.ayi * mat.bzr * mat2.cxr + mat2.ayr * mat.bzr * mat2.cxi + mat2.ayr * mat.bzi * mat2.cxr + mat2.axi * mat.bzi * mat2.cyi - mat2.axi * mat.bzr * mat2.cyr - mat2.axr * mat.bzr * mat2.cyi - mat2.axr * mat.bzi * mat2.cyr + mat2.azi * mat.byi * mat2.cxi - mat2.azi * mat.byr * mat2.cxr - mat2.azr * mat.byr * mat2.cxi - mat2.azr * mat.byi * mat2.cxr + mat2.ayi * mat.bxi * mat2.czi - mat2.ayi * mat.bxr * mat2.czr - mat2.ayr * mat.bxr * mat2.czi - mat2.ayr * mat.bxi * mat2.czr;
        this.real += mat2.axr * mat2.byr * mat.czr - mat2.axi * mat2.byi * mat.czr - mat2.axi * mat2.byr * mat.czi - mat2.axr * mat2.byi * mat.czi + mat2.azr * mat2.bxr * mat.cyr - mat2.azi * mat2.bxi * mat.cyr - mat2.azi * mat2.bxr * mat.cyi - mat2.azr * mat2.bxi * mat.cyi + mat2.ayr * mat2.bzr * mat.cxr - mat2.ayi * mat2.bzi * mat.cxr - mat2.ayi * mat2.bzr * mat.cxi - mat2.ayr * mat2.bzi * mat.cxi - mat2.axr * mat2.bzr * mat.cyr + mat2.axi * mat2.bzi * mat.cyr + mat2.axi * mat2.bzr * mat.cyi + mat2.axr * mat2.bzi * mat.cyi - mat2.azr * mat2.byr * mat.cxr + mat2.azi * mat2.byi * mat.cxr + mat2.azi * mat2.byr * mat.cxi + mat2.azr * mat2.byi * mat.cxi - mat2.ayr * mat2.bxr * mat.czr + mat2.ayi * mat2.bxi * mat.czr + mat2.ayi * mat2.bxr * mat.czi + mat2.ayr * mat2.bxi * mat.czi;
        this.imag += -mat2.axi * mat2.byi * mat.czi + mat2.axi * mat2.byr * mat.czr + mat2.axr * mat2.byr * mat.czi + mat2.axr * mat2.byi * mat.czr - mat2.azi * mat2.bxi * mat.cyi + mat2.azi * mat2.bxr * mat.cyr + mat2.azr * mat2.bxr * mat.cyi + mat2.azr * mat2.bxi * mat.cyr - mat2.ayi * mat2.bzi * mat.cxi + mat2.ayi * mat2.bzr * mat.cxr + mat2.ayr * mat2.bzr * mat.cxi + mat2.ayr * mat2.bzi * mat.cxr + mat2.axi * mat2.bzi * mat.cyi - mat2.axi * mat2.bzr * mat.cyr - mat2.axr * mat2.bzr * mat.cyi - mat2.axr * mat2.bzi * mat.cyr + mat2.azi * mat2.byi * mat.cxi - mat2.azi * mat2.byr * mat.cxr - mat2.azr * mat2.byr * mat.cxi - mat2.azr * mat2.byi * mat.cxr + mat2.ayi * mat2.bxi * mat.czi - mat2.ayi * mat2.bxr * mat.czr - mat2.ayr * mat2.bxr * mat.czi - mat2.ayr * mat2.bxi * mat.czr;
        return this;
    }

    public final Complex scalarProduct(Vec vec, Vec vec2) {
        this.real = vec.xr * vec2.xr - vec.xi * vec2.xi + vec.yr * vec2.yr - vec.yi * vec2.yi + vec.zr * vec2.zr - vec.zi * vec2.zi;
        this.imag = vec.xr * vec2.xi + vec.xi * vec2.xr + vec.yr * vec2.yi + vec.yi * vec2.yr + vec.zr * vec2.zi + vec.zi * vec2.zr;
        return this;
    }

    public final Complex scalarProductConjugate(Vec vec, Vec vec2) {
        this.real = vec.xr * vec2.xr + vec.xi * vec2.xi + vec.yr * vec2.yr + vec.yi * vec2.yi + vec.zr * vec2.zr + vec.zi * vec2.zi;
        this.imag = vec.xr * vec2.xi - vec.xi * vec2.xr + vec.yr * vec2.yi - vec.yi * vec2.yr + vec.zr * vec2.zi - vec.zi * vec2.zr;
        return this;
    }

    public final Complex matrixEval(Mat mat, Vec vec) {
        double d = mat.axr * vec.xr - mat.axi * vec.xi + mat.ayr * vec.yr - mat.ayi * vec.yi + mat.azr * vec.zr - mat.azi * vec.zi;
        double d2 = mat.bxr * vec.xr - mat.bxi * vec.xi + mat.byr * vec.yr - mat.byi * vec.yi + mat.bzr * vec.zr - mat.bzi * vec.zi;
        double d3 = mat.cxr * vec.xr - mat.cxi * vec.xi + mat.cyr * vec.yr - mat.cyi * vec.yi + mat.czr * vec.zr - mat.czi * vec.zi;
        double d4 = mat.axr * vec.xi + mat.axi * vec.xr + mat.ayr * vec.yi + mat.ayi * vec.yr + mat.azr * vec.zi + mat.azi * vec.zr;
        double d5 = mat.bxr * vec.xi + mat.bxi * vec.xr + mat.byr * vec.yi + mat.byi * vec.yr + mat.bzr * vec.zi + mat.bzi * vec.zr;
        double d6 = mat.cxr * vec.xi + mat.cxi * vec.xr + mat.cyr * vec.yi + mat.cyi * vec.yr + mat.czr * vec.zi + mat.czi * vec.zr;
        this.real = vec.xr * d - vec.xi * d4 + vec.yr * d2 - vec.yi * d5 + vec.zr * d3 - vec.zi * d6;
        this.imag = vec.xr * d4 + vec.xi * d + vec.yr * d5 + vec.yi * d2 + vec.zr * d6 + vec.zi * d3;
        return this;
    }

    public final boolean almostEquals(Complex complex) {
        double d = complex.real - this.real;
        double d2 = complex.imag - this.imag;
        return d < 1.0E-10 && d > -1.0E-10 && d2 < 1.0E-10 && d2 > -1.0E-10;
    }

    public final boolean isAlmostZero() {
        return this.real < 1.0E-10 && this.real > -1.0E-10 && this.imag < 1.0E-10 && this.imag > -1.0E-10;
    }

    public final boolean isAlmostReal() {
        return this.imag < 1.0E-6 && this.imag > -1.0E-6;
    }

    public final Complex sqrt() {
        double d = Math.sqrt(Math.sqrt(this.real * this.real + this.imag * this.imag));
        double d2 = Math.atan2(this.imag, this.real);
        this.imag = d * Math.sin(d2 / 2.0);
        this.real = d * Math.cos(d2 / 2.0);
        return this;
    }

    public final Complex maxValue(Mat mat) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        this.real = mat.axr;
        this.imag = mat.axi;
        double d9 = mat.axr * mat.axr + mat.axi * mat.axi;
        double d10 = mat.ayr * mat.ayr + mat.ayi * mat.ayi;
        if (d9 < d8) {
            d9 = d10;
            this.real = mat.ayr;
            this.imag = mat.ayi;
        }
        d10 = mat.azr * mat.azr + mat.azi * mat.azi;
        if (d9 < d7) {
            d9 = d10;
            this.real = mat.azr;
            this.imag = mat.azi;
        }
        d10 = mat.bxr * mat.bxr + mat.bxi * mat.bxi;
        if (d9 < d6) {
            d9 = d10;
            this.real = mat.bxr;
            this.imag = mat.bxi;
        }
        d10 = mat.byr * mat.byr + mat.byi * mat.byi;
        if (d9 < d5) {
            d9 = d10;
            this.real = mat.byr;
            this.imag = mat.byi;
        }
        d10 = mat.bzr * mat.bzr + mat.bzi * mat.bzi;
        if (d9 < d4) {
            d9 = d10;
            this.real = mat.bzr;
            this.imag = mat.bzi;
        }
        d10 = mat.cxr * mat.cxr + mat.cxi * mat.cxi;
        if (d9 < d3) {
            d9 = d10;
            this.real = mat.cxr;
            this.imag = mat.cxi;
        }
        d10 = mat.cyr * mat.cyr + mat.cyi * mat.cyi;
        if (d9 < d2) {
            d9 = d10;
            this.real = mat.cyr;
            this.imag = mat.cyi;
        }
        d10 = mat.czr * mat.czr + mat.czi * mat.czi;
        if (d9 < d) {
            d9 = d10;
            this.real = mat.czr;
            this.imag = mat.czi;
        }
        return this;
    }

    public final String toString() {
        return String.valueOf((float)this.real) + "+i*" + (float)this.imag;
    }

    public final String toPrintString() {
        StringBuffer stringBuffer = new StringBuffer(40);
        PGFormat.format(stringBuffer, this);
        return stringBuffer.toString();
    }

    public final void linComb(Tracable tracable, Tracable tracable2, Complex complex) {
        Complex complex2 = (Complex)tracable;
        Complex complex3 = (Complex)tracable2;
        this.real = (1.0 - complex.real) * complex2.real + complex.imag * complex2.imag + complex.real * complex3.real - complex.imag * complex3.imag;
        this.imag = (1.0 - complex.real) * complex2.imag - complex.imag * complex2.real + complex.real * complex3.imag + complex.imag * complex3.real;
    }

    public final Complex disturb(double d) {
        double d2 = Math.sqrt(this.abs2()) * d;
        this.real += (Math.random() - 0.5) * d2;
        this.imag += (Math.random() - 0.5) * d2;
        return this;
    }

    public final Complex log(Complex complex) {
        double d = Math.sqrt(complex.abs2());
        this.imag = Math.atan2(complex.imag, complex.real);
        if (complex.imag < 0.0) {
            this.imag += Math.PI * 2;
        }
        this.real = Math.log(d);
        return this;
    }

    public final Complex exp(Complex complex) {
        double d = Math.exp(complex.real);
        this.imag = d * Math.sin(complex.imag);
        this.real = d * Math.cos(complex.imag);
        return this;
    }

    static {
        new Complex();
        one = new Complex(1.0);
        new Complex(-1.0);
        new Complex(0.0, 1.0);
        e1 = new Complex(-0.5, Math.sqrt(3.0) * 0.5);
        e2 = new Complex(-0.5, -Math.sqrt(3.0) * 0.5);
        new DecimalFormat("###.##");
    }
}

