/*
 * Decompiled with CFR 0.152.
 */
package de.cinderella.ports;

import de.cinderella.Cindy;
import de.cinderella.controls.ObservableBool;
import de.cinderella.geometry.Geometry;
import de.cinderella.geometry.Hyperbolic;
import de.cinderella.geometry.PGConic;
import de.cinderella.geometry.PGElement;
import de.cinderella.geometry.PGFlat;
import de.cinderella.geometry.PGLine;
import de.cinderella.geometry.PGLocus;
import de.cinderella.geometry.PGPoint;
import de.cinderella.geometry.PGPolygon;
import de.cinderella.geometry.PGSegment;
import de.cinderella.geometry.PGText;
import de.cinderella.math.DoublePoint;
import de.cinderella.math.Vec;
import de.cinderella.ports.Appearance;
import de.cinderella.ports.PSHandler;
import de.cinderella.ports.ViewPort;
import de.cinderella.ports.ViewPortElement;
import de.cinderella.ports.ViewPortElementVector;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.PrintJob;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.PrintWriter;
import java.util.Observer;

public class EuclideanPort
extends ViewPort
implements ComponentListener,
Observer {
    public double f41 = 25.0;
    public Point f355 = new Point(100, 300);
    public Point f356 = new Point(100, 300);
    public double f357 = 25.0;
    public double f131 = 0.01;
    public int f358;
    public Vec f359 = new Vec();
    public ObservableBool f360 = new ObservableBool("mesh", false);
    public ObservableBool f361 = new ObservableBool("axes", false);
    public ObservableBool f362 = new ObservableBool("snap", false);
    public Vec f363 = new Vec();
    public Vec f364 = new Vec();
    public Vec f365 = new Vec();
    public Vec f366 = new Vec();
    public Vec f367 = new Vec();
    public Vec f368 = new Vec();
    public Vec f369 = new Vec();
    public Vec f370 = new Vec();
    public int f371 = 3;
    public String f8;
    public Point f89 = new Point();
    public DoublePoint f82 = new DoublePoint();
    public DoublePoint f83 = new DoublePoint();
    public Vec f117 = new Vec();
    public Vec f118 = new Vec();

    public EuclideanPort() {
        this.f360.addObserver(this);
        this.f361.addObserver(this);
        this.f362.addObserver(this);
        c131 c1312 = new c131(this.f362);
        c1312.m132(this.f362, true, this.f361, false, this.f360, true);
        c1312.m132(this.f362, true, this.f360, false, this.f361, true);
        c1312 = new c131(this.f360);
        c1312.m132(this.f360, false, this.f361, false, this.f362, false);
        c1312 = new c131(this.f361);
        c1312.m132(this.f360, false, this.f361, false, this.f362, false);
        Dimension dimension = this.pref;
        this.width = dimension.width;
        this.height = dimension.height;
        this.reset();
    }

    public final ViewPortElement fittingPGElement(PGElement pGElement) {
        if (pGElement instanceof PGPoint) {
            if (this.polar) {
                return new c126(pGElement, this);
            }
            return new c124(pGElement, this);
        }
        if (pGElement instanceof PGLine) {
            if (this.polar) {
                return new c124(pGElement, this);
            }
            return new c126(pGElement, this);
        }
        if (pGElement instanceof PGSegment) {
            if (this.polar) {
                return new c124(pGElement, this);
            }
            return new c126(pGElement, this);
        }
        if (pGElement instanceof PGLocus) {
            return new c122(pGElement, this);
        }
        if (pGElement instanceof PGText) {
            if (this.polar) {
                return null;
            }
            return new c123(pGElement, this);
        }
        if (pGElement instanceof PGConic) {
            return new c125(pGElement, this);
        }
        if (pGElement instanceof PGPolygon) {
            if (this.polar) {
                return null;
            }
            return new c121(pGElement, this);
        }
        return null;
    }

    public final void toVec(Point point, Vec vec) {
        this.toVec(point.x, point.y, vec);
    }

    public final void toVec(int n, int n2, Vec vec) {
        vec.assign((double)(n - this.f355.x) / this.f41, (double)(n2 - this.f355.y) / this.f41, 1.0);
    }

    public final void m102(double d, double d2, Vec vec) {
        vec.assign((d - (double)this.f355.x) / this.f41, (d2 - (double)this.f355.y) / this.f41, 1.0);
    }

    public final void toVecGrid(Point point, Vec vec) {
        vec.assign((double)(point.x - this.f355.x) / this.f41, (double)(point.y - this.f355.y) / this.f41, 1.0);
        if (this.f362.value && this.f360.value) {
            this.f359.assign((double)Math.round(vec.xr / this.f131) * this.f131, (double)Math.round(vec.yr / this.f131) * this.f131, 1.0);
            double d = this.f359.xr - vec.xr;
            double d2 = this.f359.yr - vec.yr;
            if (d * d + d2 * d2 < this.f131 * this.f131 / 30.0) {
                vec.assign(this.f359);
            }
        }
    }

    public final boolean toPoint(Vec vec, Point point) {
        double d;
        double d2;
        if (vec.zr == 0.0 && vec.zi == 0.0) {
            return false;
        }
        if (vec.zi == 0.0) {
            d2 = vec.xr / vec.zr;
            d = vec.yr / vec.zr;
        } else {
            double d3 = vec.zr * vec.zr + vec.zi * vec.zi;
            d2 = (vec.xr * vec.zr + vec.xi * vec.zi) / d3;
            d = (vec.yr * vec.zr + vec.yi * vec.zi) / d3;
        }
        point.move((int)(d2 * this.f41 + (double)this.f355.x), (int)(d * this.f41 + (double)this.f355.y));
        return true;
    }

    public final boolean toPoint(Vec vec, DoublePoint doublePoint) {
        double d;
        double d2;
        if (vec.zr == 0.0 && vec.zi == 0.0) {
            return false;
        }
        if (vec.zi == 0.0) {
            d2 = vec.xr / vec.zr;
            d = vec.yr / vec.zr;
        } else {
            double d3 = vec.zr * vec.zr + vec.zi * vec.zi;
            d2 = (vec.xr * vec.zr + vec.xi * vec.zi) / d3;
            d = (vec.yr * vec.zr + vec.yi * vec.zi) / d3;
        }
        doublePoint.x = d2 * this.f41 + (double)this.f355.x;
        doublePoint.y = d * this.f41 + (double)this.f355.y;
        return true;
    }

    public final void m103(Point point, Point point2) {
        this.f355.x += point2.x - point.x;
        this.f355.y += point2.y - point.y;
        this.m110();
    }

    public final void m104() {
        this.f357 = this.f41;
        this.f356.move(this.f355.x, this.f355.y);
    }

    public final boolean m105() {
        return this.f41 < 10000.0;
    }

    public final boolean m106() {
        return this.f41 > 1.0E-4;
    }

    public final synchronized boolean m107(Point point, double d, double d2) {
        if (this.f357 * (1.0 - d2 + d * d2) > 10000.0) {
            d2 = (10000.0 / this.f357 - 1.0) / (-1.0 + d);
        }
        if (this.f357 * (1.0 - d2 + d * d2) < 1.0E-4) {
            d2 = (1.0E-4 / this.f357 - 1.0) / (-1.0 + d);
        }
        if (d2 > 1.0E-12) {
            this.f355.move(this.f356.x, this.f356.y);
            this.f41 = this.f357;
            this.f355.x = (int)((double)this.f355.x * (1.0 - d2 + d * d2));
            this.f355.y = (int)((double)this.f355.y * (1.0 - d2 + d * d2));
            this.f355.x = (int)((double)this.f355.x - (double)point.x * d * d2);
            this.f355.y = (int)((double)this.f355.y - (double)point.y * d * d2);
            this.f41 *= 1.0 - d2 + d * d2;
            this.m111();
            this.m110();
            return true;
        }
        return false;
    }

    public final void m108() {
        this.m111();
        this.m110();
        this.repaint();
    }

    public final void componentResized(ComponentEvent componentEvent) {
        super.componentResized(componentEvent);
        if (this.width > 0 && this.height > 0) {
            this.m110();
        }
    }

    public final void m109() {
        Point point = new Point(-1, -1);
        Point point2 = new Point(-1, this.height + 1);
        Point point3 = new Point(this.width + 1, -1);
        Point point4 = new Point(this.width + 1, this.height + 1);
        Vec vec = new Vec(0.0, 0.0, 0.0);
        Vec vec2 = new Vec(0.0, 0.0, 0.0);
        Vec vec3 = new Vec(0.0, 0.0, 0.0);
        Vec vec4 = new Vec(0.0, 0.0, 0.0);
        this.toVec(point, vec);
        this.toVec(point2, vec2);
        this.toVec(point3, vec3);
        this.toVec(point4, vec4);
        Vec vec5 = new Vec(0.0, 0.0, 0.0);
        vec5.cross(vec, vec2);
        this.f363.assign(vec5);
        vec5.cross(vec2, vec4);
        this.f366.assign(vec5);
        vec5.cross(vec4, vec3);
        this.f365.assign(vec5);
        vec5.cross(vec3, vec);
        this.f364.assign(vec5);
        point.setLocation(this.f371, this.f371);
        point2.setLocation(this.f371, this.height - this.f371);
        point3.setLocation(this.width - this.f371, this.f371);
        point4.setLocation(this.width - this.f371, this.height - this.f371);
        this.toVec(point, vec);
        this.toVec(point2, vec2);
        this.toVec(point3, vec3);
        this.toVec(point4, vec4);
        vec5.cross(vec, vec2);
        this.f367.assign(vec5);
        vec5.cross(vec2, vec4);
        this.f370.assign(vec5);
        vec5.cross(vec4, vec3);
        this.f369.assign(vec5);
        vec5.cross(vec3, vec);
        this.f368.assign(vec5);
        this.elements.resize(this.width, this.height);
        this.elements.forceRecalc();
    }

    public final void m110() {
        this.m109();
        this.m111();
        this.repaint();
    }

    public final void setKernel(Cindy cindy) {
        super.setKernel(cindy);
        cindy.f16.addObserver(this);
    }

    public final void m111() {
        double d = 50.0 / this.f41;
        double d2 = Math.floor(Math.log(d) / Math.log(10.0));
        double d3 = 1.0;
        double[] dArray = new double[]{0.25, 0.5, 1.0, 2.5, 5.0, 10.0, 25.0, 50.0};
        int n = 4;
        if (this.f358 < -2) {
            this.f358 = -2;
        }
        if (this.f358 > 2) {
            this.f358 = 2;
        }
        if (d2 < 0.0) {
            while (d2 < 0.0) {
                d3 /= 10.0;
                d2 += 1.0;
            }
        } else if (d2 > 0.0) {
            while (d2 > 0.0) {
                d3 *= 10.0;
                d2 -= 1.0;
            }
        }
        n = d > 10.0 * d3 * 0.8 ? 5 : (d > 5.0 * d3 * 0.8 ? 4 : (d > 2.5 * d3 * 0.8 ? 3 : 2));
        this.f131 = d3 * dArray[n -= this.f358];
    }

    public final void m112(Graphics graphics, int n, int n2, int n3, double d) {
        if (this.width - n - n3 < 7) {
            n -= n3;
        }
        if (this.height - n2 < 7) {
            n2 -= n3;
        }
        graphics.setColor(this.lineCT.black.level[4]);
        graphics.drawLine(n, n2, n + n3, n2);
        graphics.drawLine(n, n2 + 1, n + n3, n2 + 1);
        graphics.drawLine(n, n2 - 1, n + n3, n2 - 1);
        graphics.drawLine(n, n2 - 3, n, n2 + 3);
        graphics.drawLine(n + n3, n2 - 3, n + n3, n2 + 3);
        this.f8 = String.valueOf(d);
        graphics.drawString(this.f8, n + 5, n2 - 3);
    }

    public final void m113(Graphics graphics) {
        this.f117.assign(0.0, 0.0, 1.0);
        this.toPoint(this.f117, this.f89);
        graphics.setColor(this.lineCT.black.level[2]);
        graphics.drawLine(this.f89.x, 0, this.f89.x, this.height);
        graphics.drawLine(this.f89.x - 1, 0, this.f89.x - 1, this.height);
        graphics.drawLine(this.f89.x + 1, 0, this.f89.x + 1, this.height);
        graphics.drawLine(0, this.f89.y, this.width, this.f89.y);
        graphics.drawLine(0, this.f89.y - 1, this.width, this.f89.y - 1);
        graphics.drawLine(0, this.f89.y + 1, this.width, this.f89.y + 1);
    }

    public final void m114(Graphics graphics, boolean bl) {
        this.f117.assign(0.0, 0.0, 1.0);
        this.toPoint(this.f117, this.f82);
        this.f117.assign(1.0, 0.0, 1.0);
        this.toPoint(this.f117, this.f83);
        double d = this.f83.x - this.f82.x;
        graphics.setColor(this.lineCT.black.level[2]);
        graphics.drawOval((int)(this.f82.x - d), (int)(this.f82.y - d + 1.0), (int)(2.0 * d), (int)(2.0 * d));
        if (bl) {
            graphics.drawOval((int)(this.f82.x - d + 1.0), (int)(this.f82.y - d), (int)(2.0 * d), (int)(2.0 * d));
            graphics.drawOval((int)(this.f82.x - d - 1.0), (int)(this.f82.y - d), (int)(2.0 * d), (int)(2.0 * d));
            graphics.drawOval((int)(this.f82.x - d), (int)(this.f82.y - d), (int)(2.0 * d), (int)(2.0 * d));
            graphics.drawOval((int)(this.f82.x - d), (int)(this.f82.y - d + 2.0), (int)(2.0 * d), (int)(2.0 * d));
        }
    }

    public final void paintMesh(Graphics graphics) {
        if (this.kernel.f16.value == Geometry.hyperbolic) {
            this.m114(graphics, false);
        }
        if (this.f360.value || this.f361.value) {
            double d;
            double d2;
            int n = this.width;
            int n2 = this.height;
            this.f117.assign(0.0, 0.0, 1.0);
            this.f118.assign(this.f131, 0.0, 1.0);
            this.toPoint(this.f117, this.f82);
            this.toPoint(this.f117, this.f89);
            this.toPoint(this.f118, this.f83);
            double d3 = this.f83.x - this.f82.x;
            this.toVec(0, 0, this.f117);
            this.f117.normalizeZ();
            this.f117.xr = Math.floor(this.f117.xr / this.f131) * this.f131;
            this.f117.yr = Math.floor(this.f117.yr / this.f131) * this.f131;
            this.toPoint(this.f117, this.f82);
            graphics.setColor(this.lineCT.black.level[1]);
            if (this.f360.value) {
                d2 = this.f82.x;
                while (d2 < (double)n) {
                    graphics.drawLine((int)d2, 0, (int)d2, n2);
                    d2 += d3;
                }
                d = this.f82.y;
                while (d < (double)n2) {
                    graphics.drawLine(0, (int)d, n, (int)d);
                    d += d3;
                }
            } else {
                int n3 = this.f89.x - 4;
                int n4 = this.f89.x + 4;
                int n5 = this.f89.y - 4;
                int n6 = this.f89.y + 4;
                d2 = this.f82.x;
                while (d2 < (double)n) {
                    graphics.drawLine((int)d2, n5, (int)d2, n6);
                    d2 += d3;
                }
                d = this.f82.y;
                while (d < (double)n2) {
                    graphics.drawLine(n3, (int)d, n4, (int)d);
                    d += d3;
                }
            }
            if (this.f361.value) {
                d -= d3;
                d2 -= 2.0 * d3;
                if (!this.f360.value) {
                    d = n2 - 10;
                    d2 = (double)(n - 10) - d3;
                }
                this.m113(graphics);
                this.m112(graphics, (int)d2, (int)d, (int)d3, this.f131);
            }
            if (this.kernel.f16.value instanceof Hyperbolic) {
                this.m114(graphics, true);
            }
        }
    }

    public final void printPS() {
        PSHandler.statement("%Here starts the individual view code");
        PSHandler.statement("gsave");
        PSHandler.clip();
        PSHandler.background();
        PSHandler.colorTable(this.pointCT, "Point");
        PSHandler.colorTable(this.lineCT, "Line");
        PSHandler.colorTable(this.polyCT, "Polygon");
        PSHandler.colorTable(this.lociCT, "Locus");
        this.m118();
        this.elements.recalcPS();
        this.elements.printPS();
        PSHandler.statement("%Now printing labels");
        PSHandler.statement("labelFont");
        this.elements.printLabelPS();
        PSHandler.statement("grestore");
        PSHandler.statement("%Here ends the individual view code");
    }

    public final void m115(int n, int n2, int n3, double d) {
        if (this.width - n - n3 < 7) {
            n -= n3;
        }
        if (this.height - n2 < 7) {
            n2 -= n3;
        }
        PSHandler.setColor("black");
        PSHandler.setLineThickness(1.0);
        PSHandler.drawLine(n, n2, n + n3, n2);
        PSHandler.setLineThickness(1.0);
        PSHandler.drawLine(n, n2 - 3, n, n2 + 3);
        PSHandler.drawLine(n + n3, n2 - 3, n + n3, n2 + 3);
        this.f8 = String.valueOf(d);
        PSHandler.text(n + 5, n2 - 3, this.f8, 0, 0);
    }

    public final void m116() {
        this.f117.assign(0.0, 0.0, 1.0);
        this.toPoint(this.f117, this.f89);
        PSHandler.setColor("black");
        PSHandler.setLineThickness(1.0);
        PSHandler.drawLine(this.f89.x, 0.0, this.f89.x, this.height);
        PSHandler.drawLine(0.0, this.f89.y, this.width, this.f89.y);
    }

    public final void m117(boolean bl) {
        this.f117.assign(0.0, 0.0, 1.0);
        this.toPoint(this.f117, this.f82);
        this.f117.assign(1.0, 0.0, 1.0);
        this.toPoint(this.f117, this.f83);
        double d = this.f83.x - this.f82.x;
        PSHandler.setColor("black");
        PSHandler.setLineThickness(0.02);
        PSHandler.drawCircle(this.f82, d);
        if (bl) {
            PSHandler.setLineThickness(1.0);
            PSHandler.drawCircle(this.f82, d);
        }
    }

    public final void m118() {
        if (this.kernel.f16.value == Geometry.hyperbolic) {
            this.m117(false);
        }
        if (this.f360.value || this.f361.value) {
            double d;
            double d2;
            int n = this.width;
            int n2 = this.height;
            this.f117.assign(0.0, 0.0, 1.0);
            this.f118.assign(this.f131, 0.0, 1.0);
            this.toPoint(this.f117, this.f82);
            this.toPoint(this.f117, this.f89);
            this.toPoint(this.f118, this.f83);
            double d3 = this.f83.x - this.f82.x;
            this.toVec(0, 0, this.f117);
            this.f117.normalizeZ();
            this.f117.xr = Math.floor(this.f117.xr / this.f131) * this.f131;
            this.f117.yr = Math.floor(this.f117.yr / this.f131) * this.f131;
            this.toPoint(this.f117, this.f82);
            PSHandler.setColor("black");
            PSHandler.setLineThickness(0.02);
            if (this.f360.value) {
                d2 = this.f82.x;
                while (d2 < (double)n) {
                    PSHandler.drawLine(d2, 0.0, d2, n2);
                    d2 += d3;
                }
                d = this.f82.y;
                while (d < (double)n2) {
                    PSHandler.drawLine(0.0, d, n, d);
                    d += d3;
                }
            } else {
                int n3 = this.f89.x - 4;
                int n4 = this.f89.x + 4;
                int n5 = this.f89.y - 4;
                int n6 = this.f89.y + 4;
                d2 = this.f82.x;
                while (d2 < (double)n) {
                    PSHandler.drawLine(d2, n5, d2, n6);
                    d2 += d3;
                }
                d = this.f82.y;
                while (d < (double)n2) {
                    PSHandler.drawLine(n3, d, n4, d);
                    d += d3;
                }
            }
            if (this.f361.value) {
                d -= d3;
                d2 -= 2.0 * d3;
                if (!this.f360.value) {
                    d = n2 - 10;
                    d2 = (double)(n - 10) - d3;
                }
                this.m116();
                this.m115((int)d2, (int)d, (int)d3, this.f131);
            }
            if (this.kernel.f16.value instanceof Hyperbolic) {
                this.m117(true);
            }
        }
    }

    public final void writeHTML(PrintWriter printWriter) {
        super.writeHTML(printWriter);
        printWriter.println("<param  name=mesh value=\"" + this.f360.value + "\">");
        printWriter.println("<param  name=axes value=\"" + this.f361.value + "\">");
        printWriter.println("<param  name=snap value=\"" + this.f362.value + "\">");
        printWriter.println("<param  name=scale value=\"" + this.f41 + "\">");
        printWriter.println("<param  name=originx value=\"" + this.f355.x + "\">");
        printWriter.println("<param  name=originy value= \"" + this.f355.y + "\">");
        printWriter.println("<param  name=deltafactor value= \"" + this.f358 + "\">");
    }

    public final void m119() {
        ++this.f358;
        this.m111();
        this.repaint();
    }

    public final void m120() {
        --this.f358;
        this.m111();
        this.repaint();
    }

    public final void reset() {
        super.reset();
        this.f41 = 25.0;
        this.f355.x = this.width / 3;
        this.f355.y = this.height * 2 / 3;
        this.m111();
        this.m110();
        this.repaint();
    }

    public final void softReset() {
        super.softReset();
        this.f41 = 25.0;
        this.f355.x = this.width / 3;
        this.f355.y = this.height * 2 / 3;
        this.m111();
        this.m110();
        this.repaint();
    }

    public final double m121() {
        return this.f131 * this.f41;
    }

    public final void m122() {
        double d = Double.MAX_VALUE;
        double d2 = -1.7976931348623157E308;
        double d3 = Double.MAX_VALUE;
        double d4 = -1.7976931348623157E308;
        boolean bl = false;
        int n = 0;
        while (n < this.elements.depth) {
            ViewPortElementVector viewPortElementVector = this.elements.plane[n];
            int n2 = viewPortElementVector.elementCount;
            int n3 = 0;
            while (n3 < n2) {
                ViewPortElement viewPortElement = viewPortElementVector.elementData[n3];
                if (viewPortElement instanceof c124 && viewPortElement.idea.f10.visibility != 0) {
                    c124 c1242 = (c124)viewPortElement;
                    if (!((PGFlat)c1242.idea).f127.isAlmostInfinity()) {
                        bl = true;
                        d = d < c1242.f82.x ? d : c1242.f82.x;
                        d3 = d3 < c1242.f82.y ? d3 : c1242.f82.y;
                        d2 = d2 > c1242.f82.x ? d2 : c1242.f82.x;
                        d4 = d4 > c1242.f82.y ? d4 : c1242.f82.y;
                    }
                }
                ++n3;
            }
            ++n;
        }
        if (bl) {
            double d5;
            Point point;
            double d6 = d2 - d;
            double d7 = d4 - d3;
            d2 = (d -= d6 * 0.1) + d6 * 1.2;
            d4 = (d3 -= d7 * 0.1) + d7 * 1.2;
            d6 *= 1.2;
            d7 *= 1.2;
            if (d6 * d6 < 1.0E-11 && d7 * d7 < 1.0E-11) {
                point = new Point((int)d - this.width / 2, (int)d3 - this.height / 2);
                d5 = 1.0;
            } else if (d6 * (double)this.height > d7 * (double)this.width) {
                d5 = d6 / (double)this.width;
                d3 = (d4 + d3 - (double)this.height * d6 / (double)this.width) / 2.0;
                point = new Point((int)d, (int)d3);
            } else {
                d5 = d7 / (double)this.height;
                d = (d2 + d - (double)this.width * d7 / (double)this.height) / 2.0;
                point = new Point((int)d, (int)d3);
            }
            this.m104();
            this.m107(point, 1.0 / d5, 1.0);
            this.m108();
        }
    }

    public final void print(PrintJob printJob) {
        int n = printJob.getPageDimension().width - 40;
        int n2 = printJob.getPageDimension().height - 40;
        Graphics graphics = printJob.getGraphics();
        double d = this.width;
        double d2 = this.height;
        double d3 = this.f355.x;
        double d4 = this.f355.y;
        double d5 = this.f41;
        double d6 = Math.min((double)n / d, (double)n2 / d2);
        if (d6 < 1.0) {
            this.f41 *= d6;
            this.f355.x = (int)((double)this.f355.x * d6);
            this.f355.y = (int)((double)this.f355.y * d6);
            this.width = (int)(d * d6);
            this.height = (int)(d2 * d6);
            this.m109();
            super.forceRecalc();
        }
        super.forceRecalc();
        graphics.translate(20, 20);
        graphics.translate((n - this.width) / 2, (n2 - this.height) / 2);
        graphics.setColor(Color.black);
        graphics.drawRect(0, 0, this.width, this.height);
        graphics.setClip(0, 0, this.width, this.height);
        graphics.setFont(Appearance.labelfont);
        this.paintMesh(graphics);
        this.elements.draw(graphics);
        this.elements.drawLabel(graphics);
        graphics.drawRect(0, 0, this.width, this.height);
        this.f355.x = (int)d3;
        this.f355.y = (int)d4;
        this.f41 = d5;
        this.width = (int)d;
        this.height = (int)d2;
        this.m109();
        super.forceRecalc();
        graphics.dispose();
    }
}

