/*
 * Decompiled with CFR 0.152.
 */
package de.cinderella.ports;

import de.cinderella.controls.ColorTable;
import de.cinderella.controls.FileOps;
import de.cinderella.controls.Preferences;
import de.cinderella.math.DoublePoint;
import de.cinderella.ports.EuclideanPort;
import de.cinderella.ports.HyperbolicPort;
import de.cinderella.ports.SphericalPort;
import de.cinderella.ports.ViewPort;
import java.awt.Color;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Date;

public class PSHandler {
    public static int offset;
    public static PrintWriter psfile;
    public static String fileName;
    public static ViewPort myPort;
    public static int w;
    public static int h;
    public static int xoff;
    public static int yoff;
    public static int mode;

    private static String format(double d) {
        if (Double.isNaN(d)) {
            return "0.0";
        }
        int n = (int)d;
        int n2 = (int)(Math.abs(d - (double)n) * 100000.0 + 100000.0);
        String string = "." + String.valueOf(n2).substring(1);
        if (string.equals(".00000")) {
            return String.valueOf(n);
        }
        if (string.equals(".99999")) {
            return String.valueOf(n + 1);
        }
        return String.valueOf(String.valueOf(n)) + string;
    }

    public static void setPort(ViewPort viewPort) {
        myPort = viewPort;
        offset = 0;
        if (viewPort instanceof SphericalPort || viewPort instanceof HyperbolicPort) {
            offset = 20;
        }
        w = viewPort.PSw();
        h = viewPort.PSh();
        xoff = viewPort.PSxOffset() + offset;
        yoff = viewPort.PSyOffset() + offset;
    }

    public static void setMode(int n) {
        mode = n;
    }

    public static int open(File file) {
        try {
            psfile = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            fileName = file.getName();
        }
        catch (Exception exception) {
            return FileOps.error("writePS", exception, file);
        }
        return 1;
    }

    public static int close(File file) {
        try {
            psfile.flush();
            psfile.close();
        }
        catch (Exception exception) {
            return FileOps.error("writePS", exception, file);
        }
        return 1;
    }

    public static int preview(File file) {
        try {
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec(Preferences.getString("cinderella.ps.previewer", "%s", file.getAbsolutePath()));
            PSHandler.myPort.kernel.m22(process);
        }
        catch (Exception exception) {}
        return 1;
    }

    public static void println(String string) {
        psfile.println(string);
    }

    public static void print(String string) {
        psfile.print(string);
    }

    private static String date() {
        return DateFormat.getDateTimeInstance().format(new Date(System.currentTimeMillis()));
    }

    public static void endit() {
        PSHandler.println("grestore");
        PSHandler.println("showpage");
        PSHandler.println("%%Trailer");
    }

    public static void init() {
        int n = w + 2 * offset;
        int n2 = h + 2 * offset;
        PSHandler.println("%!PS-Adobe-2.0 EPSF-2.0");
        PSHandler.println("%%Title: " + fileName);
        PSHandler.println("%%Creator: Cinderella Version 1.0");
        PSHandler.println("%%Port: " + myPort.getClass().getName());
        PSHandler.println("%%CreationDate: " + PSHandler.date());
        PSHandler.println("%%Orientation: Portrait");
        PSHandler.println("%%BoundingBox: " + (297 - n / 2) + " " + (420 - n2 / 2) + " " + (297 + n / 2) + " " + (420 + n2 / 2));
        PSHandler.println("%%Pages: 0");
        PSHandler.println("%%EndComments");
        PSHandler.println("%%EndPageSetup");
        PSHandler.println("gsave");
        PSHandler.println("");
        PSHandler.println(String.valueOf(297 - n / 2) + " " + (420 - n2 / 2) + " translate");
        PSHandler.println("");
        PSHandler.println("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
        PSHandler.println("% Drawing mode:                                 %");
        PSHandler.println("% mode=0: color  /  mode=1: gray  /  mode=2: bw %");
        PSHandler.println("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
        PSHandler.println("/mode " + mode + " def");
        PSHandler.println("");
        PSHandler.println("");
        PSHandler.println("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
        PSHandler.println("% Use original colors:                          %");
        PSHandler.println("% origcol=0: yes  /  origcol=1: no              %");
        PSHandler.println("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
        PSHandler.println("/origcol 1 def");
        PSHandler.println("");
        PSHandler.println("");
        PSHandler.println("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
        PSHandler.println("% Background color  (default white)             %");
        PSHandler.println("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
        PSHandler.defColor(Color.white, "background");
        PSHandler.defColor(PSHandler.myPort.pointCT.background.full, "origBack");
        PSHandler.println("");
        PSHandler.println("");
        PSHandler.println("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
        PSHandler.println("% Text and Mesh color                           %");
        PSHandler.println("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
        PSHandler.defColor(Color.black, "black");
        PSHandler.defColor(PSHandler.myPort.pointCT.black.full, "origBlack");
        PSHandler.println("");
        PSHandler.println("");
        PSHandler.println("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
        PSHandler.println("% Weight for gray conversion                    %");
        PSHandler.println("% Only relevant in mode=1                       %");
        PSHandler.println("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
        PSHandler.println("/rweigth {.3} def");
        PSHandler.println("/gweigth {.5} def");
        PSHandler.println("/bweigth {.2} def");
        PSHandler.println("");
        PSHandler.println("");
        PSHandler.println("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
        PSHandler.println("% Opacity of the sphere                         %");
        PSHandler.println("% Only relevant for spherical view              %");
        PSHandler.println("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
        PSHandler.println("/opaque 0.2 def");
        PSHandler.println("");
        PSHandler.println("");
        PSHandler.println("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
        PSHandler.println("% Dashing Type                                  %");
        PSHandler.println("% Used for the background of the sphere in b/w  %");
        PSHandler.println("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
        PSHandler.println("/dash {[1 2] 0 setdash} def");
        PSHandler.println("");
        PSHandler.println("");
        PSHandler.println("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
        PSHandler.println("% Fonts                                          %");
        PSHandler.println("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
        PSHandler.println("/labelFont {" + Preferences.getPSFont("cinderella.label.font") + "} def");
        PSHandler.println("/textFont {" + Preferences.getPSFont("cinderella.text.font") + "} def");
        PSHandler.println("");
        PSHandler.println("");
        PSHandler.println("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
        PSHandler.println("% END OF SETUP                                  %");
        PSHandler.println("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
        PSHandler.println("");
        PSHandler.println("");
        PSHandler.println("");
        PSHandler.println("% evetually switch do original colors");
        PSHandler.println("origcol 0 eq {/background {origBack} def /black {origBlack} def} if");
        PSHandler.println("% extract background colors");
        PSHandler.println("background /blue exch def /green exch def /red exch def");
        PSHandler.println("/backgroundfill {blue 1 eq green 1 eq red 1 eq and and");
        PSHandler.println("       {newpath} {background setrgbcolor fill} ifelse} def");
        PSHandler.println("% define color modes");
        PSHandler.println("/rgb0 {setrgbcolor} def");
        PSHandler.println("/rgb1 {bweigth mul 3 1 roll");
        PSHandler.println("       gweigth mul 3 1 roll");
        PSHandler.println("       rweigth mul add add setgray} def");
        PSHandler.println("/rgb2 {blue eq 3 1 roll ");
        PSHandler.println("       green eq 3 1 roll ");
        PSHandler.println("       red eq and and {background} {black} ifelse setrgbcolor} def");
        PSHandler.println("% set color mode");
        PSHandler.println("mode 0 eq {/rgb {rgb0} def} if");
        PSHandler.println("mode 1 eq {/rgb {rgb1} def} if");
        PSHandler.println("mode 2 eq {/rgb {rgb2} def} if");
        PSHandler.println("% redefine of fillcolors for polygons");
        PSHandler.println("mode 0 eq {/fillit {eofill} def} if");
        PSHandler.println("mode 1 eq {/fillit {eofill} def} if");
        PSHandler.println("mode 2 eq {/fillit {myfill} def} if");
        PSHandler.println("% reset states");
        PSHandler.println("/backmode 0 def");
        PSHandler.println("/lastgray 0 def");
        PSHandler.println("% special setlinewidth and fill");
        PSHandler.println("1 setlinecap");
        PSHandler.println("/setlw {backmode 1 eq mode 2 eq and {opaque mul dash} if setlinewidth} def");
        PSHandler.println("/circlefill {backmode 1 eq mode 2 eq and {fill} {fill} ifelse} def");
        PSHandler.println("/pointfill {backmode 1 eq mode 2 eq and {opaque mul 0 360 arc fill} {0 360 arc fill} ifelse} def");
        PSHandler.println("% rgb with alpha");
        PSHandler.println("/rgbalpha {");
        PSHandler.println("  backmode 1 eq {opaque mul} if /alpha exch def /alpha1 1 alpha sub def");
        PSHandler.println("  alpha mul blue  alpha1 mul add 3 1 roll");
        PSHandler.println("  alpha mul green alpha1 mul add 3 1 roll");
        PSHandler.println("  alpha mul red   alpha1 mul add 3 1 roll");
        PSHandler.println("  rgb");
        PSHandler.println("} def");
        PSHandler.println("% special fill for polygons");
        PSHandler.println("/myfill {");
        PSHandler.println("   /col {1 1 1} def");
        PSHandler.println("   lastgray 0 eq {/diff 1000 def /angle1 0 def /angle2 0 def /col {1 1 1} def } if");
        PSHandler.println("   lastgray 1 eq {/diff 1000 def /angle1 0 def /angle2 0 def /col {0 0 0} def } if");
        PSHandler.println("   lastgray 2 eq {/diff 2 def /angle1 30 def /angle2 30 def} if");
        PSHandler.println("   lastgray 3 eq {/diff 2 def /angle1 -30 def /angle2 30 def} if");
        PSHandler.println("   lastgray 4 eq {/diff 2 def /angle1 -30 def /angle2 -30 def} if");
        PSHandler.println("   lastgray 5 eq {/diff 4 def /angle1 60 def /angle2 60 def} if");
        PSHandler.println("   lastgray 6 eq {/diff 4 def /angle1 -60 def /angle2 60 def} if");
        PSHandler.println("   lastgray 7 eq {/diff 4 def /angle1 -60 def /angle2 -60 def} if");
        PSHandler.println("   lastgray 8 eq {/diff 6 def /angle1 90 def /angle2 90 def} if");
        PSHandler.println("   lastgray 9 eq {/diff 6 def /angle1 -90 def /angle2 -90 def} if");
        PSHandler.println("   lastgray 10 eq {/diff 6 def /angle1 -90 def /angle2 90 def} if");
        PSHandler.println("   lastgray 11 eq {/diff 8 def /angle1 30 def /angle2 30 def} if");
        PSHandler.println("   lastgray 12 eq {/diff 8 def /angle1 -30 def /angle2 30 def} if");
        PSHandler.println("   lastgray 12 eq {/diff 8 def /angle1 -30 def /angle2 -30 def} if");
        PSHandler.println("   lastgray 13 eq {/diff 8 def /angle1 45 def /angle2 45 def} if");
        PSHandler.println("   lastgray 14 eq {/diff 8 def /angle1 45 def /angle2 -45 def} if");
        PSHandler.println("   lastgray 15 eq {/diff 8 def /angle1 -45 def /angle2 -45 def} if");
        PSHandler.println("   eoclip");
        PSHandler.println("   col setrgbcolor");
        PSHandler.println("   clippath fill");
        PSHandler.println("   0 0 0 setrgbcolor");
        PSHandler.println("   gsave");
        PSHandler.println("   angle1 rotate");
        PSHandler.println("   0.5 setlinewidth");
        PSHandler.println("   " + -2 * h + " diff " + 2 * h + " {");
        PSHandler.println("      /tmp exch def");
        PSHandler.println("      " + -2 * w + " tmp neg moveto");
        PSHandler.println("      " + 4 * w + " 0 rlineto stroke");
        PSHandler.println("   } for");
        PSHandler.println("   grestore");
        PSHandler.println("   gsave");
        PSHandler.println("   angle2 rotate");
        PSHandler.println("   0.5 setlinewidth");
        PSHandler.println("   " + -2 * h + " diff " + 2 * h + " {");
        PSHandler.println("      /tmp exch def");
        PSHandler.println("      " + -2 * w + " tmp neg moveto");
        PSHandler.println("      " + 4 * w + " 0 rlineto stroke");
        PSHandler.println("   } for");
        PSHandler.println("   grestore");
        PSHandler.println("} def");
        PSHandler.println("% allow special iso characters");
        PSHandler.println("/reencodeISO {");
        PSHandler.println("        dup dup findfont dup length dict begin");
        PSHandler.println("        { 1 index /FID ne { def }{ pop pop } ifelse");
        PSHandler.println("        } forall");
        PSHandler.println("        /Encoding ISOLatin1Encoding def");
        PSHandler.println("        currentdict end definefont");
        PSHandler.println("} def");
        PSHandler.println("% set font");
        PSHandler.println("/Times-Roman reencodeISO def");
        PSHandler.println("/Times-Bold reencodeISO def");
        PSHandler.println("/Times-Italic reencodeISO def");
        PSHandler.println("/Times-BoldItalic reencodeISO def");
        PSHandler.println("/Helvetica reencodeISO def");
        PSHandler.println("/Helvetica-Bold reencodeISO def");
        PSHandler.println("/Helvetica-Oblique reencodeISO def");
        PSHandler.println("/Helvetica-BoldOblique reencodeISO def");
        PSHandler.println("/Courier reencodeISO def");
        PSHandler.println("/Courier-Bold reencodeISO def");
        PSHandler.println("/Courier-Oblique reencodeISO def");
        PSHandler.println("/Courier-BoldOblique reencodeISO def");
        PSHandler.println("textFont");
        PSHandler.println("");
        PSHandler.println("");
        PSHandler.println("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
        PSHandler.println("% END OF PROGRAMS                               %");
        PSHandler.println("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
        PSHandler.println("");
        PSHandler.println("");
    }

    public static String coord(DoublePoint doublePoint) {
        return PSHandler.coord(doublePoint.x, doublePoint.y);
    }

    public static String coord(double d, double d2) {
        return String.valueOf(PSHandler.format((double)xoff + d)) + " " + PSHandler.format((double)(-yoff) - d2 + (double)h + (double)(2 * offset));
    }

    public static void createContent() {
        PSHandler.init();
        myPort.printPS();
        PSHandler.endit();
    }

    public static void boundpath(int n) {
        PSHandler.println(String.valueOf(offset - n) + " " + (offset - n) + " moveto");
        PSHandler.println("0 " + (h + 2 * n) + " rlineto");
        PSHandler.println(String.valueOf(w + 2 * n) + " 0 rlineto");
        PSHandler.println("0 " + (-h - 2 * n) + " rlineto");
        PSHandler.println("closepath");
    }

    public static void clip() {
        if (myPort instanceof EuclideanPort) {
            PSHandler.boundpath(0);
        } else {
            PSHandler.boundpath(3);
        }
        PSHandler.println("clip newpath");
    }

    public static void background() {
        PSHandler.boundpath(0);
        PSHandler.println("backgroundfill");
    }

    public static void backModeOn() {
        PSHandler.println("gsave /backmode 1 def");
    }

    public static void backModeOff() {
        PSHandler.println("/backmode 0 def grestore");
    }

    public static String color(Color color) {
        return String.valueOf(PSHandler.format((double)color.getRed() / 255.0)) + " " + PSHandler.format((double)color.getGreen() / 255.0) + " " + PSHandler.format((double)color.getBlue() / 255.0);
    }

    public static void colorTable(ColorTable colorTable, String string) {
        PSHandler.comment(" Color map for " + string);
        int n = 0;
        while (n < colorTable.table.length) {
            PSHandler.defColor(colorTable.table[n].full, string, n);
            ++n;
        }
    }

    public static void defColor(Color color, String string) {
        PSHandler.print("/" + string + " { ");
        PSHandler.print(PSHandler.color(color));
        PSHandler.println(" } def");
    }

    public static void defColor(Color color, String string, int n) {
        PSHandler.print("/Col" + string + n + " { ");
        PSHandler.print(PSHandler.color(color));
        PSHandler.println(" } def");
    }

    public static void defBlack(Color color) {
        PSHandler.defColor(color, "black");
    }

    public static void statement(String string) {
        PSHandler.println(string);
    }

    public static void comment(String string) {
        PSHandler.println("%" + string);
    }

    public static void text(DoublePoint doublePoint, String string, int n, int n2) {
        string = PSHandler.prepareString(string);
        PSHandler.println(String.valueOf(PSHandler.coord(doublePoint)) + " " + n2 + " add exch " + n + " add exch moveto (" + string + ") show");
        PSHandler.println("newpath");
    }

    public static String prepareString(String string) {
        PSHandler.replace(string, "(", "\\(");
        PSHandler.replace(string, ")", "\\)");
        return string;
    }

    public static String replace(String string, String string2, String string3) {
        int n = 0;
        while ((n = string.indexOf(string2, n)) != -1) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string.substring(0, string.indexOf(string2, n)));
            stringBuffer.append(string3);
            stringBuffer.append(string.substring(string.indexOf(string2, n) + string2.length()));
            n += string3.length() - string2.length() + 1;
            string = stringBuffer.toString();
        }
        return string;
    }

    public static void text(double d, double d2, String string, int n, int n2) {
        string = PSHandler.prepareString(string);
        PSHandler.println(String.valueOf(PSHandler.coord(d, d2)) + " " + n2 + " add exch " + n + " add exch moveto (" + string + ") show");
        PSHandler.println("newpath");
    }

    public static void setColor(String string) {
        PSHandler.println(String.valueOf(string) + " setrgbcolor");
    }

    public static void setColor(String string, double d) {
        PSHandler.println(String.valueOf(string) + " " + PSHandler.format(d) + " rgbalpha");
    }

    public static void setColor(String string, int n, double d) {
        PSHandler.println("Col" + string + n + " " + PSHandler.format(d) + " rgbalpha");
    }

    public static void fillPoint(DoublePoint doublePoint, double d) {
        PSHandler.println(String.valueOf(PSHandler.coord(doublePoint)) + " " + PSHandler.format(d) + "  pointfill");
    }

    public static void drawCircle(DoublePoint doublePoint, double d) {
        PSHandler.println(String.valueOf(PSHandler.coord(doublePoint)) + " " + PSHandler.format(d) + "  0 360 arc stroke");
    }

    public static void clipCircle(double d, double d2, double d3) {
        PSHandler.println(String.valueOf(PSHandler.coord(d, d2)) + " " + PSHandler.format(d3) + "  0 360 arc clip newpath");
    }

    public static void drawCircle(double d, double d2, double d3) {
        PSHandler.println(String.valueOf(PSHandler.coord(d, d2)) + " " + PSHandler.format(d3) + "  0 360 arc stroke");
    }

    public static void drawLine(DoublePoint doublePoint, DoublePoint doublePoint2) {
        PSHandler.println(String.valueOf(PSHandler.coord(doublePoint)) + " moveto " + PSHandler.coord(doublePoint2) + " lineto stroke");
    }

    public static void drawLine(double d, double d2, double d3, double d4) {
        PSHandler.println(String.valueOf(PSHandler.coord(d, d2)) + " moveto " + PSHandler.coord(d3, d4) + " lineto stroke");
    }

    public static void lineTo(double d, double d2) {
        PSHandler.println(String.valueOf(PSHandler.coord(d, d2)) + " lineto");
    }

    public static void moveTo(double d, double d2) {
        PSHandler.println(String.valueOf(PSHandler.coord(d, d2)) + " moveto");
    }

    public static void polyPath(double[] dArray, double[] dArray2, int n, int n2) {
        PSHandler.println(" newpath ");
        PSHandler.println(String.valueOf(PSHandler.coord(dArray[n], dArray2[n])) + " moveto ");
        int n3 = n;
        while (n3 < n2) {
            PSHandler.println(String.valueOf(PSHandler.coord(dArray[n3], dArray2[n3])) + " lineto ");
            ++n3;
        }
    }

    public static void polyPath(double[] dArray, double[] dArray2, int n, int n2, int n3, double d, double d2) {
        PSHandler.println(" newpath ");
        PSHandler.println(String.valueOf(PSHandler.coord(dArray[n] * (double)n3 + d, dArray2[n] * (double)n3 + d2)) + " moveto ");
        int n4 = n;
        while (n4 < n2) {
            PSHandler.println(String.valueOf(PSHandler.coord(dArray[n4] * (double)n3 + d, dArray2[n4] * (double)n3 + d2)) + " lineto ");
            ++n4;
        }
    }

    public static void drawPolyClosed(double[] dArray, double[] dArray2, int n) {
        PSHandler.drawPolyClosed(dArray, dArray2, 0, n);
    }

    public static void drawPolyClosed(double[] dArray, double[] dArray2, int n, int n2) {
        PSHandler.polyPath(dArray, dArray2, n, n2);
        PSHandler.println("closepath stroke newpath");
    }

    public static void drawPoly(double[] dArray, double[] dArray2, int n) {
        PSHandler.drawPoly(dArray, dArray2, 0, n);
    }

    public static void drawPoly(double[] dArray, double[] dArray2, int n, int n2) {
        PSHandler.polyPath(dArray, dArray2, n, n2);
        PSHandler.println("stroke newpath");
    }

    public static void drawPoly(double[] dArray, double[] dArray2, int n, int n2, int n3, double d, double d2) {
        PSHandler.polyPath(dArray, dArray2, n, n2, n3, d, d2);
        PSHandler.println("stroke newpath");
    }

    public static void fillPoly(double[] dArray, double[] dArray2, int n) {
        PSHandler.fillPoly(dArray, dArray2, 0, n);
    }

    public static void fillRect(double d, double d2, double d3, double d4) {
        PSHandler.println(String.valueOf(PSHandler.coord(d, d2)) + " moveto");
        PSHandler.println(String.valueOf(PSHandler.format(d3)) + " 0 rlineto");
        PSHandler.println("0 " + PSHandler.format(-d4) + " rlineto");
        PSHandler.println(String.valueOf(PSHandler.format(-d3)) + " 0 rlineto");
        PSHandler.println(" closepath fill newpath");
    }

    public static void fillPoly(double[] dArray, double[] dArray2, int n, int n2) {
        PSHandler.println("gsave");
        PSHandler.polyPath(dArray, dArray2, n, n2);
        PSHandler.println("fillit newpath");
        PSHandler.println("grestore");
    }

    public static void forceFillPoly(double[] dArray, double[] dArray2, int n) {
        PSHandler.forceFillPoly(dArray, dArray2, 0, n);
    }

    public static void forceFillPoly(double[] dArray, double[] dArray2, int n, int n2) {
        PSHandler.println("gsave");
        PSHandler.polyPath(dArray, dArray2, n, n2);
        PSHandler.println("fill newpath");
        PSHandler.println("grestore");
    }

    public static void setLineThickness(double d) {
        PSHandler.println(String.valueOf(PSHandler.format(d)) + " setlw");
    }
}

