/*
 * Decompiled with CFR 0.152.
 */
package de.cinderella.controls;

import de.cinderella.Cindy;
import de.cinderella.algorithms.Locus;
import de.cinderella.controls.ColorTable;
import de.cinderella.controls.ObservableBool;
import de.cinderella.controls.ObservableInt;
import de.cinderella.geometry.PGConic;
import de.cinderella.geometry.PGElement;
import de.cinderella.geometry.PGFlat;
import de.cinderella.geometry.PGLocus;
import de.cinderella.geometry.PGPoint;
import de.cinderella.geometry.PGPolygon;
import de.cinderella.geometry.PGSegment;
import de.cinderella.geometry.PGVector;
import de.cinderella.geometry.UndoLight;
import de.cinderella.geometry.UndoList;
import de.cinderella.geometry.UndoObject;
import de.cinderella.geometry.UndoRefresher;
import de.cinderella.ports.Appearance;
import de.cinderella.ports.ArrowType;
import java.io.Serializable;
import java.util.Observable;
import java.util.Observer;

public class Defaults
implements Serializable,
Observer,
UndoRefresher {
    public ColorTable lineCT = new ColorTable(ColorTable.BRIGHT);
    public ColorTable pointCT = new ColorTable(ColorTable.BRIGHT);
    public ColorTable polyCT = new ColorTable(ColorTable.PASTELL);
    public ColorTable lociCT = new ColorTable(ColorTable.BRIGHT);
    public ObservableInt lineColor = new ObservableInt("lineColor", 3, true);
    public ObservableInt pointColor = new ObservableInt("pointColor", 2, true);
    public ObservableInt lociColor = new ObservableInt("lociColor", 1, true);
    public ObservableInt polyColor = new ObservableInt("polyColor", 11, true);
    public ObservableInt visibility = new ObservableInt("visibility", 9, true);
    public ObservableInt clipping = new ObservableInt("cliping", 0, true);
    public ObservableInt overlap = new ObservableInt("overlap", 0, true);
    public ObservableBool labeled = new ObservableBool("labeled", true, true);
    public ObservableBool pinned = new ObservableBool("pinned", false, true);
    public ObservableInt pointSize = new ObservableInt("pointSize", 5, true);
    public ObservableInt lineSize = new ObservableInt("lineSize", 1, true);
    public ObservableInt arrowType = new ObservableInt("arrowType", 3, true);
    public ObservableInt arrowMode = new ObservableInt("arrowMode", 0, true);
    public ObservableInt arrowFraction = new ObservableInt("arrowFraction", 100, true);
    public ObservableInt arrowSize = new ObservableInt("arrowSize", 8, true);
    public UndoList undoList;
    public transient Cindy kernel;

    public Defaults() {
        this.lineColor.addObserver(this);
        this.pointColor.addObserver(this);
        this.polyColor.addObserver(this);
        this.lociColor.addObserver(this);
        this.visibility.addObserver(this);
        this.clipping.addObserver(this);
        this.overlap.addObserver(this);
        this.labeled.addObserver(this);
        this.pinned.addObserver(this);
        this.pointSize.addObserver(this);
        this.lineSize.addObserver(this);
        this.arrowType.addObserver(this);
        this.arrowMode.addObserver(this);
        this.arrowFraction.addObserver(this);
        this.arrowSize.addObserver(this);
    }

    public final void setKernel(Cindy cindy) {
        this.kernel = cindy;
        this.pointCT.addObserver(cindy);
        this.lineCT.addObserver(cindy);
        this.polyCT.addObserver(cindy);
        this.lociCT.addObserver(cindy);
    }

    public final void setBackground(ColorTable colorTable) {
        if (this.pointCT != colorTable) {
            this.pointCT.setBackground(colorTable.background.full);
        }
        if (this.lineCT != colorTable) {
            this.lineCT.setBackground(colorTable.background.full);
        }
        if (this.polyCT != colorTable) {
            this.polyCT.setBackground(colorTable.background.full);
        }
        if (this.lociCT != colorTable) {
            this.lociCT.setBackground(colorTable.background.full);
        }
    }

    public final void setBlack(ColorTable colorTable) {
        if (this.pointCT != colorTable) {
            this.pointCT.setBlack(colorTable.black.full);
        }
        if (this.lineCT != colorTable) {
            this.lineCT.setBlack(colorTable.black.full);
        }
        if (this.polyCT != colorTable) {
            this.polyCT.setBlack(colorTable.black.full);
        }
        if (this.lociCT != colorTable) {
            this.lociCT.setBlack(colorTable.black.full);
        }
    }

    public final void setHighlight(ColorTable colorTable) {
        if (this.pointCT != colorTable) {
            this.pointCT.setHighlight(colorTable.highlight.full);
        }
        if (this.lineCT != colorTable) {
            this.lineCT.setHighlight(colorTable.highlight.full);
        }
        if (this.polyCT != colorTable) {
            this.polyCT.setHighlight(colorTable.highlight.full);
        }
        if (this.lociCT != colorTable) {
            this.lociCT.setHighlight(colorTable.highlight.full);
        }
    }

    public final ArrowType getArrowType() {
        return new ArrowType(this.arrowMode.value, this.arrowType.value, this.arrowFraction.value, this.arrowSize.value);
    }

    public final Appearance getLineAppearance() {
        return new Appearance(this.lineColor.value, this.pointSize.value, this.lineSize.value, this.clipping.value, this.overlap.value, this.visibility.value, this.labeled.value, this.pinned.value);
    }

    public final Appearance getConicAppearance() {
        return new Appearance(this.lineColor.value, this.pointSize.value, this.lineSize.value, 0, this.overlap.value, this.visibility.value, this.labeled.value, this.pinned.value);
    }

    public final Appearance getLociAppearance() {
        return new Appearance(this.lociColor.value, this.pointSize.value, this.lineSize.value, 0, this.overlap.value, this.visibility.value, this.labeled.value, this.pinned.value);
    }

    public final Appearance getPolyAppearance() {
        return new Appearance(this.polyColor.value, this.pointSize.value, this.lineSize.value, 0, this.overlap.value, this.visibility.value, this.labeled.value, this.pinned.value);
    }

    public final Appearance getPointAppearance() {
        return new Appearance(this.pointColor.value, this.pointSize.value, this.lineSize.value, this.clipping.value, this.overlap.value, this.visibility.value, this.labeled.value, this.pinned.value);
    }

    public final Appearance getDefaultAppearance(PGElement pGElement) {
        if (pGElement instanceof PGPoint) {
            return this.getPointAppearance();
        }
        if (pGElement instanceof PGLocus) {
            return this.getLociAppearance();
        }
        if (pGElement instanceof PGPolygon) {
            return this.getPolyAppearance();
        }
        if (pGElement instanceof PGConic) {
            return this.getConicAppearance();
        }
        return this.getLineAppearance();
    }

    public final void update(Observable observable, Object object) {
        Object object2;
        int n = 0;
        if (observable == this.pointSize) {
            n = 1;
        } else if (observable == this.lineSize) {
            n = 2;
        } else if (observable == this.pointColor) {
            n = 3;
        } else if (observable == this.lineColor) {
            n = 4;
        } else if (observable == this.polyColor) {
            n = 5;
        } else if (observable == this.lociColor) {
            n = 11;
        } else if (observable == this.clipping) {
            n = 6;
        } else if (observable == this.labeled) {
            n = 7;
        } else if (observable == this.visibility) {
            n = 8;
        } else if (observable == this.overlap) {
            n = 9;
        } else if (observable == this.pinned) {
            n = 10;
        } else if (observable == this.arrowSize) {
            n = 14;
        } else if (observable == this.arrowType) {
            n = 13;
        } else if (observable == this.arrowFraction) {
            n = 15;
        } else if (observable == this.arrowMode) {
            n = 12;
        }
        PGVector pGVector = this.kernel.f15.pgelements.getSelection();
        this.undoList = new UndoList("ChangeAppearance");
        this.undoList.refresher = this;
        int n2 = 0;
        while (n2 < pGVector.size()) {
            object2 = (PGElement)pGVector.elementAt(n2);
            if (((PGElement)object2).f2) {
                Appearance appearance = ((PGElement)object2).f9;
                UndoLight undoLight = new UndoLight();
                undoLight.createUndo(new Appearance(appearance), appearance);
                UndoLight undoLight2 = new UndoLight();
                if (object2 instanceof PGSegment) {
                    undoLight2.createUndo(new ArrowType(((PGSegment)object2).f10), ((PGSegment)object2).f10);
                }
                switch (n) {
                    case 1: {
                        appearance.point_thickness = this.pointSize.value;
                        break;
                    }
                    case 2: {
                        appearance.line_thickness = this.lineSize.value;
                        break;
                    }
                    case 3: {
                        if (!(object2 instanceof PGPoint)) break;
                        appearance.color = this.pointColor.value;
                        break;
                    }
                    case 11: {
                        if (!(((PGElement)object2).f8 instanceof Locus)) break;
                        appearance.color = this.lociColor.value;
                        break;
                    }
                    case 4: {
                        if (object2 instanceof PGPoint || object2 instanceof PGPolygon || ((PGElement)object2).f8 instanceof Locus) break;
                        appearance.color = this.lineColor.value;
                        break;
                    }
                    case 5: {
                        if (!(object2 instanceof PGPolygon)) break;
                        appearance.color = this.polyColor.value;
                        break;
                    }
                    case 6: {
                        if (!(object2 instanceof PGFlat)) break;
                        appearance.clipping = this.clipping.value;
                        break;
                    }
                    case 7: {
                        appearance.labeled = this.labeled.value;
                        break;
                    }
                    case 10: {
                        appearance.pinned = this.pinned.value;
                        break;
                    }
                    case 8: {
                        appearance.visibility = this.visibility.value;
                        break;
                    }
                    case 9: {
                        appearance.overlap = this.overlap.value;
                        break;
                    }
                    case 12: {
                        if (!(object2 instanceof PGSegment)) break;
                        ((PGSegment)object2).f10.mode = this.arrowMode.value;
                        break;
                    }
                    case 14: {
                        if (!(object2 instanceof PGSegment)) break;
                        ((PGSegment)object2).f10.size = this.arrowSize.value;
                        break;
                    }
                    case 15: {
                        if (!(object2 instanceof PGSegment)) break;
                        ((PGSegment)object2).f10.fraction = this.arrowFraction.value;
                        break;
                    }
                    case 13: {
                        if (!(object2 instanceof PGSegment)) break;
                        ((PGSegment)object2).f10.type = this.arrowType.value;
                        break;
                    }
                }
                if (!(object2 instanceof PGLocus)) {
                    ((PGElement)object2).f8.changed = -1;
                }
                this.undoList.addUndo(undoLight);
                if (object2 instanceof PGSegment) {
                    this.undoList.addUndo(undoLight2);
                }
            }
            ++n2;
        }
        object2 = this.kernel.f23.lastUndo();
        if (object2 == null || !((UndoObject)object2).similarTo(this.undoList)) {
            this.kernel.m12(this.undoList);
        }
        this.kernel.f17.redraw();
    }

    public final boolean refreshAfterUndo(Object object) {
        this.kernel.f17.forceRecalc();
        this.kernel.f17.redraw();
        return true;
    }
}

