/*
 * Decompiled with CFR 0.152.
 */
package de.cinderella.math;

import de.cinderella.geometry.Restorer;
import de.cinderella.math.Assignable;
import java.io.Serializable;

public final class DoublePoint
implements Serializable,
Assignable,
Restorer {
    public double x;
    public double y;

    public DoublePoint() {
        this.x = 0.0;
        this.y = 0.0;
    }

    public DoublePoint(DoublePoint doublePoint) {
        this.x = doublePoint.x;
        this.y = doublePoint.y;
    }

    public final void move(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public final void assign(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public final void assign(Assignable assignable) {
        this.x = ((DoublePoint)assignable).x;
        this.y = ((DoublePoint)assignable).y;
    }

    public final boolean equals(DoublePoint doublePoint) {
        return this.x == doublePoint.x && this.y == doublePoint.y;
    }

    public final Object clone() {
        return new DoublePoint(this);
    }

    public final boolean resembles(Object object) {
        return this.equals((DoublePoint)object);
    }

    public final void restore(Object object) {
        ((DoublePoint)object).assign(this);
    }

    public final void save(Object object) {
        this.assign((DoublePoint)object);
    }

    public final void add(double d, double d2) {
        this.x += d;
        this.y += d2;
    }

    public final void assign(DoublePoint doublePoint) {
        this.x = doublePoint.x;
        this.y = doublePoint.y;
    }

    public final DoublePoint mid(DoublePoint doublePoint, DoublePoint doublePoint2) {
        this.x = (doublePoint.x + doublePoint2.x) / 2.0;
        this.y = (doublePoint.y + doublePoint2.y) / 2.0;
        return this;
    }

    public static double rad(DoublePoint doublePoint, DoublePoint doublePoint2) {
        double d = (doublePoint.x - doublePoint2.x) / 2.0;
        double d2 = (doublePoint.y - doublePoint2.y) / 2.0;
        return Math.sqrt(d * d + d2 * d2);
    }
}

