/*
 * Decompiled with CFR 0.152.
 */
package de.cinderella.math;

import de.cinderella.geometry.PGFormat;
import de.cinderella.geometry.Restorer;
import de.cinderella.math.Assignable;
import de.cinderella.math.Complex;
import de.cinderella.math.Mat;
import de.cinderella.math.Tracable;

public final class Vec
implements Tracable,
Assignable,
Restorer {
    public double xr;
    public double xi;
    public double yr;
    public double yi;
    public double zr;
    public double zi;
    public int invalid;
    public static final Vec e1 = new Vec(1.0, 0.0, 0.0);
    public static final Vec e3;
    public static final Vec cub1;
    public static final Vec cub2;
    public static final Vec cub3;

    public Vec() {
    }

    public Vec(double d, double d2, double d3) {
        this.xr = d;
        this.yr = d2;
        this.zr = d3;
        this.invalid = 0;
    }

    public Vec(Complex complex, Complex complex2, Complex complex3) {
        this.xr = complex.real;
        this.yr = complex2.real;
        this.zr = complex3.real;
        this.xi = complex.imag;
        this.yi = complex2.imag;
        this.zi = complex3.imag;
        this.invalid = 0;
    }

    public Vec(Vec vec) {
        this.xr = vec.xr;
        this.yr = vec.yr;
        this.zr = vec.zr;
        this.xi = vec.xi;
        this.yi = vec.yi;
        this.zi = vec.zi;
        this.invalid = vec.invalid;
    }

    public final void assign(Assignable assignable) {
        this.assign((Vec)assignable);
    }

    public final Vec assign(Vec vec) {
        this.xr = vec.xr;
        this.yr = vec.yr;
        this.zr = vec.zr;
        this.xi = vec.xi;
        this.yi = vec.yi;
        this.zi = vec.zi;
        this.invalid = vec.invalid;
        return this;
    }

    public final boolean equals(Vec vec) {
        return this.xr == vec.xr && this.yr == vec.yr && this.zr == vec.zr && this.xi == vec.xi && this.yi == vec.yi && this.zi == vec.zi && this.invalid == vec.invalid;
    }

    public final Object clone() {
        return new Vec(this);
    }

    public final boolean resembles(Object object) {
        return this.equals((Vec)object);
    }

    public final void restore(Object object) {
        ((Vec)object).assign(this);
    }

    public final void save(Object object) {
        this.assign((Vec)object);
    }

    public final Vec assign(double d, double d2, double d3) {
        this.xr = d;
        this.xi = 0.0;
        this.yr = d2;
        this.yi = 0.0;
        this.zr = d3;
        this.zi = 0.0;
        this.invalid = 0;
        return this;
    }

    public final Vec assign(double d, double d2, double d3, double d4, double d5, double d6) {
        this.xr = d;
        this.yr = d3;
        this.zr = d5;
        this.xi = d2;
        this.yi = d4;
        this.zi = d6;
        this.invalid = 0;
        return this;
    }

    public final Vec setInvalide() {
        this.xr = 0.0;
        this.yr = 0.0;
        this.zr = 0.0;
        this.xi = 0.0;
        this.yi = 0.0;
        this.zi = 0.0;
        this.invalid = 1;
        return this;
    }

    public final Vec c(Mat mat) {
        this.xr = mat.cxr;
        this.yr = mat.cyr;
        this.zr = mat.czr;
        this.xi = mat.cxi;
        this.yi = mat.cyi;
        this.zi = mat.czi;
        return this;
    }

    public final Vec mul(double d) {
        this.xr *= d;
        this.xi *= d;
        this.yr *= d;
        this.yi *= d;
        this.zr *= d;
        this.zi *= d;
        return this;
    }

    public final Vec mul(Complex complex) {
        double d = complex.real;
        double d2 = complex.imag;
        double d3 = this.xr * d - this.xi * d2;
        double d4 = this.xi * d + this.xr * d2;
        this.xr = d3;
        this.xi = d4;
        d3 = this.yr * d - this.yi * d2;
        d4 = this.yi * d + this.yr * d2;
        this.yr = d3;
        this.yi = d4;
        d3 = this.zr * d - this.zi * d2;
        d4 = this.zi * d + this.zr * d2;
        this.zr = d3;
        this.zi = d4;
        return this;
    }

    public final Vec mul(double d, double d2) {
        double d3 = this.xr * d - this.xi * d2;
        double d4 = this.xi * d + this.xr * d2;
        this.xr = d3;
        this.xi = d4;
        d3 = this.yr * d - this.yi * d2;
        d4 = this.yi * d + this.yr * d2;
        this.yr = d3;
        this.yi = d4;
        d3 = this.zr * d - this.zi * d2;
        d4 = this.zi * d + this.zr * d2;
        this.zr = d3;
        this.zi = d4;
        return this;
    }

    public final Vec div(double d) {
        this.xr /= d;
        this.xi /= d;
        this.yr /= d;
        this.yi /= d;
        this.zr /= d;
        this.zi /= d;
        return this;
    }

    public final Vec add(Vec vec) {
        this.xr += vec.xr;
        this.yr += vec.yr;
        this.zr += vec.zr;
        this.xi += vec.xi;
        this.yi += vec.yi;
        this.zi += vec.zi;
        return this;
    }

    public final Vec sub(Vec vec) {
        this.xr -= vec.xr;
        this.yr -= vec.yr;
        this.zr -= vec.zr;
        this.xi -= vec.xi;
        this.yi -= vec.yi;
        this.zi -= vec.zi;
        return this;
    }

    public final Vec cross(Vec vec, Vec vec2) {
        this.xr = vec.yr * vec2.zr - vec.yi * vec2.zi - vec.zr * vec2.yr + vec.zi * vec2.yi;
        this.xi = vec.yr * vec2.zi + vec.yi * vec2.zr - vec.zr * vec2.yi - vec.zi * vec2.yr;
        this.yr = vec.zr * vec2.xr - vec.zi * vec2.xi - vec.xr * vec2.zr + vec.xi * vec2.zi;
        this.yi = vec.zr * vec2.xi + vec.zi * vec2.xr - vec.xr * vec2.zi - vec.xi * vec2.zr;
        this.zr = vec.xr * vec2.yr - vec.xi * vec2.yi - vec.yr * vec2.xr + vec.yi * vec2.xi;
        this.zi = vec.xr * vec2.yi + vec.xi * vec2.yr - vec.yr * vec2.xi - vec.yi * vec2.xr;
        return this;
    }

    public final Vec cross(Vec vec) {
        double d = this.yr * vec.zr - this.yi * vec.zi - this.zr * vec.yr + this.zi * vec.yi;
        double d2 = this.yr * vec.zi + this.yi * vec.zr - this.zr * vec.yi - this.zi * vec.yr;
        double d3 = this.zr * vec.xr - this.zi * vec.xi - this.xr * vec.zr + this.xi * vec.zi;
        double d4 = this.zr * vec.xi + this.zi * vec.xr - this.xr * vec.zi - this.xi * vec.zr;
        double d5 = this.xr * vec.yr - this.xi * vec.yi - this.yr * vec.xr + this.yi * vec.xi;
        double d6 = this.xr * vec.yi + this.xi * vec.yr - this.yr * vec.xi - this.yi * vec.xr;
        this.xr = d;
        this.yr = d3;
        this.zr = d5;
        this.xi = d2;
        this.yi = d4;
        this.zi = d6;
        return this;
    }

    public final Vec polar(Mat mat) {
        double d = mat.axr * this.xr + mat.bxr * this.yr + mat.cxr * this.zr - mat.axi * this.xi - mat.bxi * this.yi - mat.cxi * this.zi;
        double d2 = mat.axr * this.xi + mat.bxr * this.yi + mat.cxr * this.zi + mat.axi * this.xr + mat.bxi * this.yr + mat.cxi * this.zr;
        double d3 = mat.ayr * this.xr + mat.byr * this.yr + mat.cyr * this.zr - mat.ayi * this.xi - mat.byi * this.yi - mat.cyi * this.zi;
        double d4 = mat.ayr * this.xi + mat.byr * this.yi + mat.cyr * this.zi + mat.ayi * this.xr + mat.byi * this.yr + mat.cyi * this.zr;
        double d5 = mat.azr * this.xr + mat.bzr * this.yr + mat.czr * this.zr - mat.azi * this.xi - mat.bzi * this.yi - mat.czi * this.zi;
        double d6 = mat.azr * this.xi + mat.bzr * this.yi + mat.czr * this.zi + mat.azi * this.xr + mat.bzi * this.yr + mat.czi * this.zr;
        this.xr = d;
        this.yr = d3;
        this.zr = d5;
        this.xi = d2;
        this.yi = d4;
        this.zi = d6;
        return this;
    }

    public final Vec mul(Mat mat) {
        double d = mat.axr * this.xr + mat.ayr * this.yr + mat.azr * this.zr - mat.axi * this.xi - mat.ayi * this.yi - mat.azi * this.zi;
        double d2 = mat.axr * this.xi + mat.ayr * this.yi + mat.azr * this.zi + mat.axr * this.xi + mat.ayr * this.yi + mat.azr * this.zi;
        double d3 = mat.bxr * this.xr + mat.byr * this.yr + mat.bzr * this.zr - mat.bxi * this.xi - mat.byi * this.yi - mat.bzi * this.zi;
        double d4 = mat.bxr * this.xi + mat.byr * this.yi + mat.bzr * this.zi + mat.bxr * this.xi + mat.byr * this.yi + mat.bzr * this.zi;
        double d5 = mat.cxr * this.xr + mat.cyr * this.yr + mat.czr * this.zr - mat.cxi * this.xi - mat.cyi * this.yi - mat.czi * this.zi;
        double d6 = mat.cxr * this.xi + mat.cyr * this.yi + mat.czr * this.zi + mat.cxr * this.xi + mat.cyr * this.yi + mat.czr * this.zi;
        this.xr = d;
        this.yr = d3;
        this.zr = d5;
        this.xi = d2;
        this.yi = d4;
        this.zi = d6;
        return this;
    }

    public final Vec prod(Mat mat, Vec vec) {
        this.xr = mat.axr * vec.xr - mat.axi * vec.xi + mat.ayr * vec.yr - mat.ayi * vec.yi + mat.azr * vec.zr - mat.azi * vec.zi;
        this.yr = mat.bxr * vec.xr - mat.bxi * vec.xi + mat.byr * vec.yr - mat.byi * vec.yi + mat.bzr * vec.zr - mat.bzi * vec.zi;
        this.zr = mat.cxr * vec.xr - mat.cxi * vec.xi + mat.cyr * vec.yr - mat.cyi * vec.yi + mat.czr * vec.zr - mat.czi * vec.zi;
        this.xi = mat.axr * vec.xi + mat.axi * vec.xr + mat.ayr * vec.yi + mat.ayi * vec.yr + mat.azr * vec.zi + mat.azi * vec.zr;
        this.yi = mat.bxr * vec.xi + mat.bxi * vec.xr + mat.byr * vec.yi + mat.byi * vec.yr + mat.bzr * vec.zi + mat.bzi * vec.zr;
        this.zi = mat.cxr * vec.xi + mat.cxi * vec.xr + mat.cyr * vec.yi + mat.cyi * vec.yr + mat.czr * vec.zi + mat.czi * vec.zr;
        return this;
    }

    public final Vec normalizeX() {
        this.invalid = 0;
        if (this.xr != 0.0 || this.xi != 0.0) {
            double d = this.xr * this.xr + this.xi * this.xi;
            double d2 = (this.yr * this.xr + this.yi * this.xi) / d;
            double d3 = (-this.yr * this.xi + this.yi * this.xr) / d;
            this.yr = d2;
            this.yi = d3;
            d2 = (this.zr * this.xr + this.zi * this.xi) / d;
            d3 = (-this.zr * this.xi + this.zi * this.xr) / d;
            this.zr = d2;
            this.zi = d3;
            this.xr = 1.0;
            this.xi = 0.0;
        } else {
            this.setInvalide();
        }
        return this;
    }

    public final Vec normalizeY() {
        this.invalid = 0;
        if (this.yr != 0.0 || this.yi != 0.0) {
            double d = this.yr * this.yr + this.yi * this.yi;
            double d2 = (this.xr * this.yr + this.xi * this.yi) / d;
            double d3 = (-this.xr * this.yi + this.xi * this.yr) / d;
            this.xr = d2;
            this.xi = d3;
            d2 = (this.zr * this.yr + this.zi * this.yi) / d;
            d3 = (-this.zr * this.yi + this.zi * this.yr) / d;
            this.zr = d2;
            this.zi = d3;
            this.yr = 1.0;
            this.yi = 0.0;
        } else {
            this.setInvalide();
        }
        return this;
    }

    public final Vec normalizeZ() {
        this.invalid = 0;
        if (this.zr != 0.0 || this.zi != 0.0) {
            double d = this.zr * this.zr + this.zi * this.zi;
            double d2 = (this.yr * this.zr + this.yi * this.zi) / d;
            double d3 = (-this.yr * this.zi + this.yi * this.zr) / d;
            this.yr = d2;
            this.yi = d3;
            d2 = (this.xr * this.zr + this.xi * this.zi) / d;
            d3 = (-this.xr * this.zi + this.xi * this.zr) / d;
            this.xr = d2;
            this.xi = d3;
            this.zr = 1.0;
            this.zi = 0.0;
        } else {
            this.setInvalide();
        }
        return this;
    }

    public final Vec normalizeAbs() {
        this.invalid = 0;
        double d = this.abs2();
        if (d != 0.0) {
            this.div(Math.sqrt(d));
        } else {
            this.setInvalide();
        }
        return this;
    }

    public final Vec normalizeMax() {
        double d;
        double d2 = this.xr;
        double d3 = this.xi;
        this.invalid = 0;
        if (this.yr * this.yr + this.yi * this.yi > d2 * d2 + d3 * d3) {
            d2 = this.yr;
            d3 = this.yi;
        }
        if (this.zr * this.zr + this.zi * this.zi > d2 * d2 + d3 * d3) {
            d2 = this.zr;
            d3 = this.zi;
        }
        if ((d = (d2 * d2 + d3 * d3) / 4.0) != 0.0) {
            double d4 = (this.xr * d2 + this.xi * d3) / d;
            double d5 = (-this.xr * d3 + this.xi * d2) / d;
            this.xr = d4;
            this.xi = d5;
            d4 = (this.yr * d2 + this.yi * d3) / d;
            d5 = (-this.yr * d3 + this.yi * d2) / d;
            this.yr = d4;
            this.yi = d5;
            d4 = (this.zr * d2 + this.zi * d3) / d;
            d5 = (-this.zr * d3 + this.zi * d2) / d;
            this.zr = d4;
            this.zi = d5;
        } else {
            this.setInvalide();
        }
        return this;
    }

    public final boolean normalizeMaxValid(int n) {
        double d = this.xr;
        double d2 = this.xi;
        if (this.yr * this.yr + this.yi * this.yi > d * d + d2 * d2) {
            d = this.yr;
            d2 = this.yi;
        }
        if (this.zr * this.zr + this.zi * this.zi > d * d + d2 * d2) {
            d = this.zr;
            d2 = this.zi;
        }
        double d3 = (d * d + d2 * d2) / 4.0;
        if (n != 0 || d3 < 1.0E-17) {
            this.xr = 0.0;
            this.xi = 0.0;
            this.yr = 0.0;
            this.yi = 0.0;
            this.zr = 0.0;
            this.zi = 0.0;
            this.invalid = 1;
            return false;
        }
        this.invalid = 0;
        if (d3 != 0.0) {
            double d4 = (this.xr * d + this.xi * d2) / d3;
            double d5 = (-this.xr * d2 + this.xi * d) / d3;
            this.xr = d4;
            this.xi = d5;
            d4 = (this.yr * d + this.yi * d2) / d3;
            d5 = (-this.yr * d2 + this.yi * d) / d3;
            this.yr = d4;
            this.yi = d5;
            d4 = (this.zr * d + this.zi * d2) / d3;
            d5 = (-this.zr * d2 + this.zi * d) / d3;
            this.zr = d4;
            this.zi = d5;
        }
        return true;
    }

    public final Vec normalize() {
        this.normalizeMax();
        this.normalizeAbs();
        return this;
    }

    public final String toString() {
        return "[" + this.xr + "+i*" + this.xi + "," + this.yr + "+i*" + this.yi + "," + this.zr + "+i*" + this.zi + "]";
    }

    public final boolean isAlmostInfinity() {
        return this.zr < 1.0E-6 && this.zr > -1.0E-6 && this.zi < 1.0E-6 && this.zi > -1.0E-6;
    }

    public final boolean isSteep() {
        return (this.xr < 0.0 ? -this.xr : this.xr) < (this.yr < 0.0 ? -this.yr : this.yr);
    }

    public final boolean almostEquals(Vec vec) {
        return this.projectiveDist(vec) < 1.0E-7;
    }

    public final boolean isAlmostReal() {
        return this.xi < 1.0E-6 && this.xi > -1.0E-6 && this.yi < 1.0E-6 && this.yi > -1.0E-6 && this.zi < 1.0E-6 && this.zi > -1.0E-6;
    }

    public final boolean isEqual(Vec vec) {
        return vec.xr == this.xr && vec.yr == this.yr && vec.zr == this.zr && vec.xi == this.xi && vec.yi == this.yi && vec.zi == this.zi;
    }

    public final boolean isZero() {
        return this.xr == 0.0 && this.yr == 0.0 && this.zr == 0.0 && this.xi == 0.0 && this.yi == 0.0 && this.zi == 0.0;
    }

    public final int maxIndex() {
        double d = this.xr * this.xr + this.xi * this.xi;
        double d2 = this.yr * this.yr + this.yi * this.yi;
        double d3 = this.zr * this.zr + this.zi * this.zi;
        if (d > d2 && d > d3) {
            return 1;
        }
        if (d2 > d3) {
            return 2;
        }
        return 3;
    }

    public final double abs2() {
        return this.xr * this.xr + this.xi * this.xi + this.yr * this.yr + this.yi * this.yi + this.zr * this.zr + this.zi * this.zi;
    }

    public final double norm() {
        return this.xi * this.xi + this.xr * this.xr + this.yi * this.yi + this.yr * this.yr + this.zi * this.zi + this.zr * this.zr;
    }

    public final double projectiveDist(Vec vec) {
        return this.projectiveDistMinScal(vec);
    }

    public final double projectiveDistMinScal(Vec vec) {
        double d = Math.sqrt(vec.abs2());
        double d2 = Math.sqrt(this.abs2());
        if (d == 0.0 || d2 == 0.0) {
            return 0.0;
        }
        double d3 = this.xr * vec.xr + this.xi * vec.xi + this.yr * vec.yr + this.yi * vec.yi + this.zr * vec.zr + this.zi * vec.zi;
        double d4 = this.xr * vec.xi - this.xi * vec.xr + this.yr * vec.yi - this.yi * vec.yr + this.zr * vec.zi - this.zi * vec.zr;
        double d5 = Math.sqrt(d3 * d3 + d4 * d4);
        if (d5 != 0.0) {
            d3 /= d5;
            d4 /= d5;
        } else {
            d3 = 1.0;
            d4 = 0.0;
        }
        double d6 = (this.xr * d3 - this.xi * d4) / d2 + vec.xr / d;
        double d7 = (this.xi * d3 + this.xr * d4) / d2 + vec.xi / d;
        double d8 = (this.yr * d3 - this.yi * d4) / d2 + vec.yr / d;
        double d9 = (this.yi * d3 + this.yr * d4) / d2 + vec.yi / d;
        double d10 = (this.zr * d3 - this.zi * d4) / d2 + vec.zr / d;
        double d11 = (this.zi * d3 + this.zr * d4) / d2 + vec.zi / d;
        double d12 = Math.sqrt(d6 * d6 + d7 * d7 + d8 * d8 + d9 * d9 + d10 * d10 + d11 * d11);
        d6 = (this.xr * d3 - this.xi * d4) / d2 - vec.xr / d;
        d7 = (this.xi * d3 + this.xr * d4) / d2 - vec.xi / d;
        d8 = (this.yr * d3 - this.yi * d4) / d2 - vec.yr / d;
        d9 = (this.yi * d3 + this.yr * d4) / d2 - vec.yi / d;
        d10 = (this.zr * d3 - this.zi * d4) / d2 - vec.zr / d;
        d11 = (this.zi * d3 + this.zr * d4) / d2 - vec.zi / d;
        double d13 = Math.sqrt(d6 * d6 + d7 * d7 + d8 * d8 + d9 * d9 + d10 * d10 + d11 * d11);
        if (d12 < d13) {
            return d12;
        }
        return d13;
    }

    public final double dist(Vec vec) {
        return (this.xr - vec.xr) * (this.xr - vec.xr) + (this.xi - vec.xi) * (this.xi - vec.xi) + (this.yr - vec.yr) * (this.yr - vec.yr) + (this.yi - vec.yi) * (this.yi - vec.yi) + (this.zr - vec.zr) * (this.zr - vec.zr) + (this.zi - vec.zi) * (this.zi - vec.zi);
    }

    public final Vec solveCubic(Complex complex, Complex complex2, Complex complex3, Complex complex4) {
        return this.solveCubic(complex.real, complex.imag, complex2.real, complex2.imag, complex3.real, complex3.imag, complex4.real, complex4.imag);
    }

    public final Vec solveCubic(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        double d9 = d * d5 - d2 * d6;
        double d10 = d * d6 + d2 * d5;
        double d11 = 4.0 * d9 - (d3 * d3 - d4 * d4);
        double d12 = 4.0 * d10 - 2.0 * d3 * d4;
        double d13 = d * d3 - d2 * d4;
        double d14 = d * d4 + d2 * d3;
        double d15 = d11 * d5 - d12 * d6 - 18.0 * (d13 * d7 - d14 * d8);
        double d16 = d11 * d6 + d12 * d5 - 18.0 * (d13 * d8 + d14 * d7);
        double d17 = 27.0 * (d * d - d2 * d2);
        double d18 = 54.0 * (d2 * d);
        double d19 = d17 * d7 - d18 * d8;
        double d20 = d17 * d8 + d18 * d7;
        double d21 = d3 * d3 - d4 * d4;
        double d22 = 2.0 * d3 * d4;
        double d23 = d21 * d3 - d22 * d4;
        double d24 = d21 * d4 + d22 * d3;
        double d25 = d19 + 4.0 * d23;
        double d26 = d20 + 4.0 * d24;
        d11 = d15 * d5 - d16 * d6 + d25 * d7 - d26 * d8;
        d12 = d15 * d6 + d16 * d5 + d25 * d8 + d26 * d7;
        d23 *= -2.0;
        d24 *= -2.0;
        d23 += 9.0 * (d13 * d5 - d14 * d6);
        d24 += 9.0 * (d13 * d6 + d14 * d5);
        d23 -= d19;
        d24 -= d20;
        d25 = Math.sqrt(Math.sqrt((d11 *= 27.0) * d11 + (d12 *= 27.0) * d12));
        d26 = Math.atan2(d12, d11);
        d12 = d25 * Math.sin(d26 / 2.0);
        d11 = d25 * Math.cos(d26 / 2.0);
        double d27 = Math.exp(Math.log(Math.sqrt((d23 += d11 * d - d12 * d2) * d23 + (d24 += d11 * d2 + d12 * d) * d24)) / 3.0);
        double d28 = Math.atan2(d24, d23);
        double d29 = d27 * Math.sin(d28 / 3.0);
        double d30 = d27 * Math.cos(d28 / 3.0);
        d27 *= d27;
        double d31 = d27 * Math.sin((d28 *= 2.0) / 3.0);
        double d32 = d27 * Math.cos(d28 / 3.0);
        this.xr = 2.0 * d21 - 6.0 * d9;
        this.xi = 2.0 * d22 - 6.0 * d10;
        this.yr = -1.5874010519681996 * (d3 * d30 - d4 * d29);
        this.yi = -1.5874010519681996 * (d3 * d29 + d4 * d30);
        this.zr = 1.2599210498948732 * d32;
        this.zi = 1.2599210498948732 * d31;
        d11 = 4.762203155904599 * (d30 * d - d29 * d2);
        d12 = 4.762203155904599 * (d30 * d2 + d29 * d);
        double d33 = d11 * d11 + d12 * d12;
        d25 = (this.xr * d11 + this.xi * d12) / d33;
        d26 = (-this.xr * d12 + this.xi * d11) / d33;
        this.xr = d25;
        this.xi = d26;
        d25 = (this.yr * d11 + this.yi * d12) / d33;
        d26 = (-this.yr * d12 + this.yi * d11) / d33;
        this.yr = d25;
        this.yi = d26;
        d25 = (this.zr * d11 + this.zi * d12) / d33;
        d26 = (-this.zr * d12 + this.zi * d11) / d33;
        this.zr = d25;
        this.zi = d26;
        return this;
    }

    public final Vec getNearest(Vec vec, Vec vec2, double d) {
        double d2;
        double d3 = this.projectiveDist(vec);
        if (d * d3 <= (d2 = this.projectiveDist(vec2)) || d2 == Double.NaN) {
            return vec;
        }
        if (d * d2 < d3 || d3 == Double.NaN) {
            return vec2;
        }
        return null;
    }

    public final Vec getNearest(Vec vec, Vec vec2, Vec vec3, Vec vec4, double d) {
        Vec vec5 = new Vec();
        Vec vec6 = new Vec();
        Vec vec7 = new Vec();
        Vec vec8 = new Vec();
        Vec vec9 = new Vec();
        vec5.assign(this);
        vec6.assign(vec);
        vec7.assign(vec2);
        vec8.assign(vec3);
        vec9.assign(vec4);
        switch (vec5.maxIndex()) {
            case 1: {
                vec5.normalizeX();
                vec6.normalizeX();
                vec7.normalizeX();
                vec8.normalizeX();
                vec9.normalizeX();
                break;
            }
            case 2: {
                vec5.normalizeY();
                vec6.normalizeY();
                vec7.normalizeY();
                vec8.normalizeY();
                vec9.normalizeY();
                break;
            }
            case 3: {
                vec5.normalizeZ();
                vec6.normalizeZ();
                vec7.normalizeZ();
                vec8.normalizeZ();
                vec9.normalizeZ();
                break;
            }
        }
        double d2 = vec5.dist(vec6);
        double d3 = vec5.dist(vec7);
        double d4 = vec5.dist(vec8);
        double d5 = vec5.dist(vec9);
        if (d * d2 <= d3 && d * d2 <= d4 && d * d2 <= d5) {
            return vec;
        }
        if (d * d3 <= d2 && d * d3 <= d4 && d * d3 <= d5) {
            return vec2;
        }
        if (d * d4 <= d2 && d * d4 <= d3 && d * d4 <= d5) {
            return vec3;
        }
        if (d * d5 <= d2 && d * d5 <= d3 && d * d5 <= d4) {
            return vec4;
        }
        return null;
    }

    public final Vec solveLinearEquation(Mat mat) {
        this.xr = mat.byr * mat.czr - mat.byi * mat.czi - mat.bzr * mat.cyr + mat.bzi * mat.cyi;
        this.xi = mat.byr * mat.czi + mat.byi * mat.czr - mat.bzr * mat.cyi - mat.bzi * mat.cyr;
        this.yr = mat.bzr * mat.cxr - mat.bzi * mat.cxi - mat.bxr * mat.czr + mat.bxi * mat.czi;
        this.yi = mat.bzr * mat.cxi + mat.bzi * mat.cxr - mat.bxr * mat.czi - mat.bxi * mat.czr;
        this.zr = mat.bxr * mat.cyr - mat.bxi * mat.cyi - mat.byr * mat.cxr + mat.byi * mat.cxi;
        this.zi = mat.bxr * mat.cyi + mat.bxi * mat.cyr - mat.byr * mat.cxi - mat.byi * mat.cxr;
        if (this.abs2() > 1.0E-10) {
            return this;
        }
        if (mat.czr * mat.czr + mat.czi * mat.czi > 1.0E-10) {
            this.xr = 0.0;
            this.xi = 0.0;
            this.yr = -mat.czr;
            this.yi = -mat.czi;
            this.zr = mat.cyr;
            this.zi = mat.cyi;
            return this;
        }
        if (mat.byr * mat.byr + mat.byi * mat.byi > 1.0E-10) {
            this.xr = 0.0;
            this.xi = 0.0;
            this.yr = -mat.bzr;
            this.yi = -mat.bzi;
            this.zr = mat.byr;
            this.zi = mat.byi;
            return this;
        }
        if (mat.axr * mat.axr + mat.axi * mat.axi < 1.0E-10) {
            this.xr = 1.0;
            this.xi = 0.0;
            this.yr = 0.0;
            this.yi = 0.0;
            this.zr = 0.0;
            this.zi = 0.0;
            return this;
        }
        this.xr = 0.0;
        this.xi = 0.0;
        this.yr = -mat.azr;
        this.yi = -mat.azi;
        this.zr = mat.ayr;
        this.zi = mat.ayi;
        return this;
    }

    public final Vec project(Mat mat, Vec vec, Vec vec2) {
        Vec vec3 = new Vec();
        Vec vec4 = new Vec();
        Vec vec5 = new Vec();
        Vec vec6 = new Vec();
        Vec vec7 = new Vec();
        vec7.center(mat).normalizeMax();
        if (mat.isEllipse()) {
            vec3.cross(this, vec7);
            vec3.normalizeMax();
            mat.intersectConicWithLine(vec3, vec, vec2);
        } else {
            mat.intersectConicWithLine(e3, vec, vec2);
            vec.normalizeAbs();
            vec2.normalizeAbs();
            vec5.assign(vec).add(vec2);
            vec6.assign(vec).sub(vec2);
            vec4.cross(vec5, vec7);
            mat.intersectConicWithLine(vec4, vec, vec2);
            vec.normalize();
            if (vec.isAlmostReal()) {
                vec3.cross(vec5, this);
                vec3.normalizeMax();
                mat.intersectConicWithLine(vec3, vec, vec2);
            } else {
                vec3.cross(vec6, this);
                vec3.normalizeMax();
                mat.intersectConicWithLine(vec3, vec, vec2);
            }
        }
        return this;
    }

    public final Vec center(Mat mat) {
        this.xr = mat.byr * mat.azr - mat.byi * mat.azi - mat.bzr * mat.ayr + mat.bzi * mat.ayi;
        this.xi = mat.byr * mat.azi + mat.byi * mat.azr - mat.bzr * mat.ayi - mat.bzi * mat.ayr;
        this.yr = mat.bzr * mat.axr - mat.bzi * mat.axi - mat.bxr * mat.azr + mat.bxi * mat.azi;
        this.yi = mat.bzr * mat.axi + mat.bzi * mat.axr - mat.bxr * mat.azi - mat.bxi * mat.azr;
        this.zr = mat.bxr * mat.ayr - mat.bxi * mat.ayi - mat.byr * mat.axr + mat.byi * mat.axi;
        this.zi = mat.bxr * mat.ayi + mat.bxi * mat.ayr - mat.byr * mat.axi - mat.byi * mat.axr;
        if (this.isAlmostZero()) {
            this.xr = mat.cxr;
            this.xi = mat.cxi;
            this.yr = mat.cyr;
            this.yi = mat.cyi;
            this.zr = 0.0;
            this.zi = 0.0;
        }
        return this;
    }

    public final String toPrintString() {
        StringBuffer stringBuffer = new StringBuffer(40);
        PGFormat.format(stringBuffer, this);
        return stringBuffer.toString();
    }

    public final Vec disturb(double d) {
        double d2 = Math.sqrt(this.abs2()) * d;
        this.xr += (Math.random() - 0.5) * d2;
        this.yr += (Math.random() - 0.5) * d2;
        this.zr += (Math.random() - 0.5) * d2;
        return this;
    }

    public final Vec random() {
        this.xr = Math.random();
        this.yr = Math.random();
        this.zr = Math.random();
        this.xi = Math.random();
        this.yi = Math.random();
        this.zi = Math.random();
        return this;
    }

    public final void linComb(Tracable tracable, Tracable tracable2, Complex complex) {
        Vec vec = (Vec)tracable;
        Vec vec2 = (Vec)tracable2;
        this.xr = (1.0 - complex.real) * vec.xr + complex.imag * vec.xi + complex.real * vec2.xr - complex.imag * vec2.xi;
        this.xi = (1.0 - complex.real) * vec.xi - complex.imag * vec.xr + complex.real * vec2.xi + complex.imag * vec2.xr;
        this.yr = (1.0 - complex.real) * vec.yr + complex.imag * vec.yi + complex.real * vec2.yr - complex.imag * vec2.yi;
        this.yi = (1.0 - complex.real) * vec.yi - complex.imag * vec.yr + complex.real * vec2.yi + complex.imag * vec2.yr;
        this.zr = (1.0 - complex.real) * vec.zr + complex.imag * vec.zi + complex.real * vec2.zr - complex.imag * vec2.zi;
        this.zi = (1.0 - complex.real) * vec.zi - complex.imag * vec.zr + complex.real * vec2.zi + complex.imag * vec2.zr;
    }

    public final boolean isAlmostZero() {
        return this.xi < 1.0E-10 && this.xi > -1.0E-10 && this.yi < 1.0E-10 && this.yi > -1.0E-10 && this.zi < 1.0E-10 && this.zi > -1.0E-10 && this.xr < 1.0E-10 && this.xr > -1.0E-10 && this.yr < 1.0E-10 && this.yr > -1.0E-10 && this.zr < 1.0E-10 && this.zr > -1.0E-10;
    }

    static {
        new Vec(0.0, 1.0, 0.0);
        e3 = new Vec(0.0, 0.0, 1.0);
        cub1 = new Vec(1.0, 1.0, 1.0);
        new Vec();
        cub2 = new Vec(Complex.e1, Complex.one, Complex.e2);
        cub3 = new Vec(Complex.e2, Complex.one, Complex.e1);
        new Vec();
        new Complex();
        new Complex();
        new Complex();
        new Complex();
        new Complex();
    }
}

