/*
 * Decompiled with CFR 0.152.
 */
package de.cinderella.ports;

import de.cinderella.algorithms.Algorithm;
import de.cinderella.geometry.PGElement;
import de.cinderella.ports.Hotlist;
import de.cinderella.ports.Resizable;
import de.cinderella.ports.ViewPort;
import de.cinderella.ports.ViewPortElement;
import java.awt.Graphics;

public final class ViewPortElementVector {
    public ViewPortElement[] elementData;
    public int elementCount;
    public ViewPort mVP;

    public ViewPortElementVector(ViewPort viewPort) {
        this.mVP = viewPort;
        this.elementData = new ViewPortElement[50];
    }

    public ViewPortElementVector(int n, ViewPort viewPort) {
        this.mVP = viewPort;
        this.elementData = new ViewPortElement[n];
    }

    public final void recalc() {
        int n = 0;
        while (n < this.elementCount) {
            ViewPortElement viewPortElement = this.elementData[n];
            PGElement pGElement = viewPortElement.idea;
            if ((pGElement.f8.changed & this.mVP.ID) != 0 && pGElement.f0 || pGElement.f9.clipping == 2) {
                viewPortElement.recalc();
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < this.elementCount) {
            this.elementData[n2].idea.f8.changed &= this.mVP.iID;
            ++n2;
        }
    }

    public final void forceRecalc() {
        int n = 0;
        while (n < this.elementCount) {
            ViewPortElement viewPortElement = this.elementData[n];
            viewPortElement.recalc();
            viewPortElement.idea.f8.changed &= this.mVP.iID;
            ++n;
        }
    }

    public final void draft(Graphics graphics) {
        int n = 0;
        while (n < this.elementCount) {
            ViewPortElement viewPortElement = this.elementData[n];
            if (viewPortElement.valid) {
                viewPortElement.draft(graphics);
            }
            ++n;
        }
    }

    public final void drawLabel(Graphics graphics) {
        int n = 0;
        while (n < this.elementCount) {
            ViewPortElement viewPortElement = this.elementData[n];
            if (viewPortElement.idea.f9.visibility != 0 && viewPortElement.valid && viewPortElement.idea.f9.labeled) {
                viewPortElement.drawLabel(graphics);
            }
            ++n;
        }
    }

    public final void draw(Graphics graphics) {
        int n = 0;
        while (n < this.elementCount) {
            ViewPortElement viewPortElement = this.elementData[n];
            if (viewPortElement.valid) {
                viewPortElement.draw(graphics);
            }
            ++n;
        }
    }

    public final void draftBack(Graphics graphics) {
        int n = 0;
        while (n < this.elementCount) {
            ViewPortElement viewPortElement = this.elementData[n];
            if (viewPortElement.valid) {
                viewPortElement.draftBack(graphics);
            }
            ++n;
        }
    }

    public final void drawBack(Graphics graphics) {
        int n = 0;
        while (n < this.elementCount) {
            ViewPortElement viewPortElement = this.elementData[n];
            if (viewPortElement.valid) {
                viewPortElement.drawBack(graphics);
            }
            ++n;
        }
    }

    public final void resize(int n, int n2) {
        int n3 = 0;
        while (n3 < this.elementCount) {
            if (this.elementData[n3] instanceof Resizable) {
                ((Resizable)((Object)this.elementData[n3])).resize(n, n2);
            }
            ++n3;
        }
    }

    public final void ensureCapacity(int n) {
        int n2 = this.elementData.length;
        if (n > n2) {
            ViewPortElement[] viewPortElementArray = this.elementData;
            int n3 = n + 50;
            this.elementData = new ViewPortElement[n3];
            System.arraycopy(viewPortElementArray, 0, this.elementData, 0, this.elementCount);
        }
    }

    public final int indexOf(ViewPortElement viewPortElement) {
        int n = 0;
        while (n < this.elementCount) {
            if (viewPortElement == this.elementData[n]) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public final void removeElementAt(int n) {
        int n2 = this.elementCount - n - 1;
        if (n2 > 0) {
            System.arraycopy(this.elementData, n + 1, this.elementData, n, n2);
        }
        --this.elementCount;
        this.elementData[this.elementCount] = null;
    }

    public final void add(ViewPortElement viewPortElement) {
        if (this.indexOf(viewPortElement) == -1) {
            this.ensureCapacity(this.elementCount + 1);
            this.elementData[this.elementCount++] = viewPortElement;
        }
    }

    public final void delete(PGElement pGElement) {
        int n = 0;
        while (n < this.elementCount) {
            if (this.elementData[n].idea == pGElement) {
                this.removeElementAt(n);
                return;
            }
            ++n;
        }
    }

    public final void clear() {
        int n = 0;
        while (n < this.elementCount) {
            this.elementData[n].idea.f3 = false;
            this.elementData[n].destroy();
            this.elementData[n] = null;
            ++n;
        }
        this.elementCount = 0;
    }

    public final void clearTmp() {
        int n = 0;
        while (n < this.elementCount) {
            this.elementData[n].destroyTmp();
            this.elementData[n] = null;
            ++n;
        }
        this.elementCount = 0;
    }

    public final boolean addHot(Hotlist hotlist) {
        boolean bl = false;
        int n = hotlist.x;
        int n2 = hotlist.y;
        int n3 = 0;
        while (n3 < this.elementCount) {
            ViewPortElement viewPortElement = this.elementData[n3];
            if (viewPortElement.valid && viewPortElement.isHot(n, n2)) {
                bl = true;
                hotlist.insert(viewPortElement.idea);
            }
            ++n3;
        }
        return bl;
    }

    public final PGElement findMovable(int n, int n2) {
        int n3 = 0;
        while (n3 < this.elementCount) {
            ViewPortElement viewPortElement = this.elementData[n3];
            if (viewPortElement.idea.isMovable() && viewPortElement.valid && viewPortElement.isHot(n, n2)) {
                return viewPortElement.idea;
            }
            ++n3;
        }
        return null;
    }

    public final ViewPortElement findLabel(int n, int n2) {
        int n3 = 0;
        while (n3 < this.elementCount) {
            ViewPortElement viewPortElement = this.elementData[n3];
            if (viewPortElement.valid && viewPortElement.idea.f9.labeled && viewPortElement.isLabelHot(n, n2)) {
                return viewPortElement;
            }
            ++n3;
        }
        return null;
    }

    public final PGElement findDockable(int n, int n2, PGElement pGElement) {
        int n3 = 0;
        while (n3 < this.elementCount) {
            ViewPortElement viewPortElement = this.elementData[n3];
            if (viewPortElement.idea.canDock() && viewPortElement.idea.f0 && (viewPortElement.idea.f1 || this.mVP.complex) && viewPortElement.isAt(n, n2, pGElement == viewPortElement.idea)) {
                return viewPortElement.idea;
            }
            ++n3;
        }
        return null;
    }

    public final Algorithm getAlgorithmAtPoint(Class clazz, int n, int n2) {
        int n3 = 0;
        while (n3 < this.elementCount) {
            ViewPortElement viewPortElement = this.elementData[n3];
            if (clazz.isInstance(viewPortElement.idea.f8) && viewPortElement.isAt(n, n2, false)) {
                return viewPortElement.idea.f8;
            }
            ++n3;
        }
        return null;
    }

    public final PGElement getElementAtPoint(Class clazz, int n, int n2) {
        int n3 = 0;
        while (n3 < this.elementCount) {
            ViewPortElement viewPortElement = this.elementData[n3];
            if (clazz.isInstance(viewPortElement.idea) && viewPortElement.isAt(n, n2, false)) {
                return viewPortElement.idea;
            }
            ++n3;
        }
        return null;
    }

    public final String toString() {
        int n = this.elementCount - 1;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        int n2 = 0;
        while (n2 <= n) {
            String string = this.elementData[n2].toString();
            stringBuffer.append(string);
            if (n2 < n) {
                stringBuffer.append(", ");
            }
            ++n2;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

